#include "tpsession.h"
#include <QDebug>

TpSession::TpSession(QString cmname)
{
    mAM = Tp::AccountManager::create();
    reqCm=cmname;
    connect(mAM->becomeReady(),
            SIGNAL(finished(Tp::PendingOperation *)),
            SLOT(onAMReady(Tp::PendingOperation *)));
    connect(mAM.data(),
            SIGNAL(accountCreated(const QString &)),
            SLOT(onAccountCreated(const QString &)));

    createObserver();
#if 0
#if 1
    reqCm="ring";
    reqAddress="+358504872320";
#else
    reqCm="gabble";
    reqAddress="kate.alhola@gmail.com";
#endif
    reqMsg="Miu mau Kate Here";
#else
    reqCm=cmname;
#endif
}

void TpSession::onAMReady(Tp::PendingOperation *op)
{
 qDebug() << "TpSession::onAMReady";
 TpSessionAccount *tpacc;

   foreach (const QString &path, mAM->allAccountPaths()) {
       accounts+=tpacc=new TpSessionAccount(mAM, path);
       connect(tpacc,SIGNAL(accountReady(TpSessionAccount*)),
                      SLOT(onAccountReady(TpSessionAccount *)));
    }

}

void TpSession::onReady(Tp::PendingOperation *)
{
};

void TpSession::onAccountCreated(const QString &path)
{

    accounts+=new TpSessionAccount(mAM, path);
}

void TpSession::onAccountReady(TpSessionAccount *tpacc)
{

    qDebug() << "Account " << tpacc->acc->cmName() << "is Ready";
    if(!reqCm.isEmpty() && tpacc->acc->cmName()==reqCm) {
     emit accountReady(tpacc);
     if(!reqMsg.isEmpty()) tpacc->sendMessageToAddress(reqAddress,reqMsg);
    }
}

TpSessionAccount* TpSession::getAccount(const  QString cm,QString protocol)
{
     qDebug() << "TpSession::getAccount" << cm << " " << protocol;
 foreach (TpSessionAccount *tpacc, accounts) {
     if((!cm.isEmpty()  && tpacc->acc->cmName()==cm) || (!protocol.isEmpty() && tpacc->acc->protocol()==protocol)) {
     qDebug() << "TpSession::getAccount found" << tpacc->acc->cmName() << " " << tpacc->acc->protocol();
     return tpacc;
     }
 }
 return NULL;
}

void TpSession::createObserver()
{

    qDebug() << __PRETTY_FUNCTION__ ;

    registrar = Tp::ClientRegistrar::create();

    Tp::ChannelClassList channelFilters;
    QMap<QString, QDBusVariant> textFilter, mediaFilter;
    // Registering Text channel observer
    textFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType"),
                  QDBusVariant(TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT));
    textFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".TargetHandleType"),
                  QDBusVariant(Tp::HandleTypeContact));
    channelFilters.append(textFilter);

    // Registering Media channel observer
    mediaFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType"),
                  QDBusVariant(TELEPATHY_INTERFACE_CHANNEL_TYPE_STREAMED_MEDIA));
    mediaFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".TargetHandleType"),
                  QDBusVariant(Tp::HandleTypeContact));
    channelFilters.append(mediaFilter);

    TpSessionObserver* observer = new TpSessionObserver( channelFilters, this );
    bool registered = registrar->registerClient(
      Tp::AbstractClientPtr::dynamicCast(Tp::SharedPtr<TpSessionObserver>(observer)),
      "TpSessionChannelObserver");

        qDebug() << "TpSession::createObserver" << (registered ? "started" : "failed");

}


void TpSession::createChannelListener(const QString &channelType,
                                   const Tp::MethodInvocationContextPtr<> &context,
                                   const Tp::AccountPtr &account,
                                   const Tp::ChannelPtr &channel)
{
    qDebug() << "TpSession::createChannelListener";

    QString channelObjectPath = channel->objectPath();


    if ( channels.contains( channelObjectPath ) &&
         !channelType.isEmpty() &&
         !channelObjectPath.isEmpty() ) {
        qDebug() << "TELEPATHY_ERROR_INVALID_ARGUMENT";
        return;
    }
    qDebug() << "creating listener for: " << channelObjectPath << " type " << channelType;
#if 0
    ChannelListener* listener = 0;
    if( channelType == TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT ) {
        listener = new TextChannelListener(account, channel, context);
    } else if ( channelType == TELEPATHY_INTERFACE_CHANNEL_TYPE_STREAMED_MEDIA ) {
        listener = new StreamChannelListener(account, channel, context);
    }

    if(listener) {
        connect(listener, SIGNAL(channelClosed(ChannelListener *)),
                this, SLOT(channelClosed(ChannelListener *)));
        Channels.append( channelObjectPath );
    }
#endif
}







