#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include "ui_mainwindow.h"
#include <Phonon>
#include <QtNetwork>
#include "options.h"
#include "lastfm.h"
#include "lmaster.h"
#include <QtSql>


class MainWindow : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    Ui::MainWindow ui;
    Phonon::MediaObject *moo ;
    Phonon::AudioOutput *device;
    Phonon::SeekSlider *slider ;
    Phonon::VolumeSlider *volume;
    //QStringList list;
    QMenu *mmenu;
    QMap<int,QStringList> list;
    QStringList queue;
    Phonon::MediaObject *metaInformationResolver;
    QProgressBar *loading;
    QDialog *ld;
    options *opt;
    lmaster *lmast;
    int rotate;
    last *scrobler;
    Phonon::VideoWidget *vwidget;
    QGraphicsScene * scene ;
    QSqlDatabase db;
    QString currentQuery;
    QMenu *tmenu;
    QMap<QString,QString> autolist;
    QStringList namefilter;
    Phonon::Effect      *eqEffect;
    QList<QSlider*> sliders;
    Phonon::Path audioPath;
public slots:
    void toggleEqualizer(bool);
    void sliderChanged (int);
    void resetAll ();
    void alistload();
    void load();
    void click1();
    void click2();
    void click3();
    void click4();
    void click5();
    void pl_sf_click();
    void pl_fn_click();
    void pl_fn_add_dir();
    void currentItemChanged ( QListWidgetItem * );
    void play_pause();
    void next();
    void prev();
    void changePlay( Phonon::State, Phonon::State ) ;
    void clear();
    void replyFinished(QNetworkReply*);
    void about();
    void drawlist();
    void getMeta(QString );
    void metaStateChanged(Phonon::State, Phonon::State);
    void ch();
    void find();
    void inform();
    void reload();
    #ifdef Q_WS_MAEMO_5
    void grabZoomKeys(bool grab);

#endif
    void dart();
    void dart2();
    void replyFinished2(QNetworkReply*);
void orientationChanged();
protected:
  void keyPressEvent(QKeyEvent* event);

};

#endif // MAINWINDOW_H
