from Error import *
from Engine import *

import ConfigParser
import os
import cPickle
import subprocess
import shutil
import cairo
from urlparse import urlparse

class AddEngine:
   def add(self, name, category, url, prefix, use_default_icon, custom_icon, color):
      
      # Basic checks to see if everything was entered
      if len(name) == 0:
         return(1, "Name is a required field")
      elif len(category) == 0:
         return(1, "Category is a required field")
      elif len(url) == 0:
         return(1, "URL is a required field")
      elif len(prefix) == 0:
         return(1, "QuickBar Prefix is a required field")
         
      # Check to see if name is taken
      ie = InstalledEngines()
      if name in ie.read():
         return (1, "The search engine '%s' already exists" % name)
      
      # Attempt to parse the URL
      try:
         url = url.replace("%", "%%")
         if not "{query}" in url:
            raise IndexError
      except Exception, e:
         error()
         return(1, "URL did not contain {query}")
      try:
         url = url.replace("{query}", "%(query)s")
         parsed_url = urlparse(url)
         lang = parsed_url.netloc.split(".")[-1]
         url.replace("." + lang + "/", "." + "%(lang)s" + "/")
         language = lang
      except Exception, e:
         error()
         return(1, "Unable to parse the URL")
         
      # Try to make the correct directory
      engine_dir = "/opt/touchsearch/search_engines/%s/" % name
      try:
         os.mkdir(engine_dir)
      except Exception, e:
         error()
         return (1, "Unable to create directory '%s'" % engine_dir)
         
      # Create/move the icon
      if use_default_icon:
         try:
            surface = cairo.ImageSurface(cairo.FORMAT_ARGB32, 122, 40)
            cr = cairo.Context(surface)
            cr.set_source_rgb(*color)
            cr.select_font_face("Sans", cairo.FONT_SLANT_NORMAL, cairo.FONT_WEIGHT_NORMAL)

            size = 5
            while (size < 30 and cr.text_extents(name)[4] < 90):
               size += 1
               cr.set_font_size(size)
               
            y = ((32 - cr.text_extents(name)[3]) / 2) + cr.text_extents(name)[3]
            x = (122 - cr.text_extents(name)[4]) / 2
               
            cr.move_to(x, y)
            cr.show_text(name)
            surface.write_to_png("%s%s.png" % (engine_dir, name.lower()))
         except Exception, e:
            error()
            return(1, "Unable to automatically create icon")
      else:
         if len(custom_icon) == 0:
            return(1, "Custom icon is a required field, if selected")
         else:
            try:
               shutil.copyfile(custom_icon, "%s%s.png" % (engine_dir, name.lower()))
            except Exception, e:
               error()

               return(1, "Unable to copy custom icon: %s" % e)
         
      # Try to create the .search file
      try:
         user_config_file = open(engine_dir + name + ".search", 'w')
         user_config_access = ConfigParser.RawConfigParser()
         
         user_config_access.set('DEFAULT', 'name', name)
         user_config_access.set('DEFAULT', 'url', url)
         user_config_access.set('DEFAULT', 'category', category)
         user_config_access.set('DEFAULT', 'color_icon', "%s.png" % name.lower())
         user_config_access.set('DEFAULT', 'list_icon', "%s_list.png" % name.lower())
         user_config_access.set('DEFAULT', 'languages', language)
         user_config_access.set('DEFAULT', 'prefix', prefix)
         user_config_access.set('DEFAULT', 'language', language)
         
         user_config_access.write(user_config_file)
         user_config_file.close()
      except Exception, e:
         error()
         return (1, "Unable to create .search file: %s" % e)
         
      ie = InstalledEngines()
      valid = ie.is_valid([name], name)
      
      if valid:
         return(0, "Search engine '%s' created" % name)
      else:
         return(1, "Unable to create search engine")
         

class InstalledEngines:
   def __init__(self):
      self.ENGINE_LIST_LOC = '/home/user/.touchsearch/search_engines.dat'
      self.ENGINES_DIR = "/opt/touchsearch/search_engines/"
      try:
         self.installed_engines = self.get_dir()
         data = open(self.ENGINE_LIST_LOC, 'r')
         self.listed_engines = cPickle.load(data)
         data.close()
         self.get_valid()
         self.write(self.search_engines)
               
      except Exception, e:
         error()
         default = ['Google']
         data = open(self.ENGINE_LIST_LOC, 'w')
         cPickle.dump(default, data)
         data.close()
         self.__init__()
         
   def get_valid(self):
         le = []
         ie = self.installed_engines
         for i, e in enumerate(self.listed_engines):
            if e in self.installed_engines:
               le.append(e)
               del ie[ie.index(e)]
         search_engines = le + ie
         self.search_engines = []
         for e in search_engines:
            if self.is_valid(search_engines, e):
               self.search_engines.append(e)

   def read(self):
      return self.search_engines
      
   def get_dir(self):
      dir_list = os.listdir(self.ENGINES_DIR)
      return dir_list

   def write(self, new_search_engines):
      data = open(self.ENGINE_LIST_LOC, 'w')
      cPickle.dump(new_search_engines, data)
      data.close()
      
   def install(self, path, engine, force=0):
      
      if engine in self.search_engines:
         if not force:
            return 1
      try:
         #unzip the file to the correct dir
         retcode = subprocess.Popen('unzip -o %s -d %s' % (path, self.ENGINES_DIR), shell=True)
         print retcode
         return 0
      except Exception, e:
         print e
         return 2
         
   def is_valid(self, engine_list, engine_name):
      # The following are tests to see if the search engine is "valid"
      
      valid = True
      print engine_list
      print engine_name
      
      if not engine_name in engine_list:
         valid = False
      else:
         try:
            engine = Engine(engine_name)
            if not os.path.exists(engine.get_color_icon()):
               valid = False
               print 'Error: "%s" does not exist or is unaccesable' % engine.get_color_icon()
            if not os.path.exists(engine.get_ghosted_icon()):
               valid = False
               print 'Error: "%s" does not exist or is unaccesable' % engine.get_ghosted_icon()
         except Exception:
            error()
            valid = False
         
      print "var valid is: %s" % valid
      return valid

class Settings:
   def __init__(self):
      self.SETTINGS_LOC = '/home/user/.touchsearch/settings.conf'
      try:
         user_config_file = open(self.SETTINGS_LOC, 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)
         
         self.search_engine = str(user_config_access.get('DEFAULT', 'search_engine'))
         self.opacity = float(user_config_access.get('DEFAULT', 'opacity'))
         self.show_corefour = int(user_config_access.get('DEFAULT', 'show_corefour'))
         self.corefour = eval(user_config_access.get('DEFAULT', 'corefour'))
         self.icon_style = str(user_config_access.get('DEFAULT', 'icon_style'))
         
         ie = InstalledEngines()
         if ie.is_valid(ie.read(), self.search_engine):
            pass
         else:
            self.search_engine = 'Google'
            
         corefour = []
         for c in self.corefour:
            if ie.is_valid(ie.read(), c):
               corefour.append(c)
            else:
               print "Unable to load %s" % c
         self.corefour = corefour
         
         user_config_file.close()
      except Exception, e:
         error()
         self.reset()
   
   def reset(self):
      user_config_file = open(self.SETTINGS_LOC, 'w')
      user_config_access = ConfigParser.RawConfigParser()
      
      user_config_access.set('DEFAULT', 'search_engine', 'Google')
      user_config_access.set('DEFAULT', 'opacity', 0.7)
      user_config_access.set('DEFAULT', 'show_corefour', 0)
      user_config_access.set('DEFAULT', 'corefour', ["Google", "Wikipedia", "Amazon"])
      user_config_access.set('DEFAULT', 'icon_style', "Color")

      user_config_access.write(user_config_file)
      user_config_file.close()
      
      self.search_engine = 'Google'
      self.opacity = 0.7
      self.show_corefour = 0
      self.corefour = ["Google", "Wikipedia", "Amazon"]
      self.icon_style = "Color"
   
   def write(self):
      user_config_file = open(self.SETTINGS_LOC, 'w')
      user_config_access = ConfigParser.RawConfigParser()
      
      user_config_access.set('DEFAULT', 'search_engine', self.search_engine)
      user_config_access.set('DEFAULT', 'opacity', self.opacity)
      user_config_access.set('DEFAULT', 'show_corefour', self.show_corefour)
      user_config_access.set('DEFAULT', 'corefour', self.corefour)
      user_config_access.set('DEFAULT', 'icon_style', self.icon_style)

      user_config_access.write(user_config_file)
      user_config_file.close()
   
   #-----------------------------------------------------------------
   #  All the accessor methods
   #-----------------------------------------------------------------
   
   def get_search_engine(self):
      return self.search_engine
      
   def get_opacity(self):
      return self.opacity
      
   def get_show_corefour(self):
      return self.show_corefour
   
   def get_corefour(self):
      return self.corefour
   
   def get_icon_style(self):
      return self.icon_style
   
   #-----------------------------------------------------------------
   #  All the mutator methods
   #-----------------------------------------------------------------
   
   def set_search_engine(self, search_engine):
      self.search_engine = search_engine
      
   def set_opacity(self, opacity):
      self.opacity = opacity
      
   def set_show_corefour(self, show_corefour):
      self.show_corefour = show_corefour
      
   def set_corefour(self, corefour):
      self.corefour = corefour
      
   def set_icon_style(self, icon_style):
      self.icon_style = icon_style