from Error import *
from Engine import *

import ConfigParser
import os
import cPickle
import subprocess

class InstalledEngines:
   def __init__(self):
      self.ENGINE_LIST_LOC = '/home/user/.touchsearch/search_engines.dat'
      self.ENGINES_DIR = "/opt/touchsearch/search_engines/"
      try:
         self.installed_engines = self.get_dir()
         data = open(self.ENGINE_LIST_LOC, 'r')
         self.listed_engines = cPickle.load(data)
         data.close()
         self.get_valid()
         self.write(self.search_engines)
               
      except Exception, e:
         error()
         default = ['Google', 'QuickBar', 'Amazon', 'Wikipedia', 'Dictionary', 'YouTube', 'Ebay', 'GoogleMapsMobile']
         data = open(self.ENGINE_LIST_LOC, 'w')
         cPickle.dump(default, data)
         data.close()
         self.__init__()
         
   def get_valid(self):
         le = []
         ie = self.installed_engines
         for i, e in enumerate(self.listed_engines):
            if e in self.installed_engines:
               le.append(e)
               del ie[ie.index(e)]
         search_engines = le + ie
         self.search_engines = []
         for e in search_engines:
            if self.is_valid(search_engines, e):
               self.search_engines.append(e)

   def read(self):
      return self.search_engines
      
   def get_dir(self):
      dir_list = os.listdir(self.ENGINES_DIR)
      return dir_list

   def write(self, new_search_engines):
      data = open(self.ENGINE_LIST_LOC, 'w')
      cPickle.dump(new_search_engines, data)
      data.close()
      
   def install(self, path, engine, force=0):
      
      if engine in self.search_engines:
         if not force:
            return 1
      try:
         #unzip the file to the correct dir
         retcode = subprocess.Popen('unzip -o %s -d %s' % (path, self.ENGINES_DIR), shell=True)
         print retcode
         return 0
      except Exception, e:
         print e
         return 2
         
   def is_valid(self, engine_list, engine_name):
      # The following are tests to see if the search engine is "valid"
      
      valid = True
      print engine_list
      print engine_name
      
      if not engine_name in engine_list:
         valid = False
      else:
         try:
            engine = Engine(engine_name)
            if not os.path.exists(engine.get_icon()):
               valid = False
               print 'Error: "%s" does not exist or is unaccesable' % engine.get_icon()
         except Exception:
            error()
            valid = False
         
      print "var valid is: %s" % valid
      return valid

class Settings:
   def __init__(self):
      self.SETTINGS_LOC = '/home/user/.touchsearch/settings.conf'
      try:
         user_config_file = open(self.SETTINGS_LOC, 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)
         
         self.search_engine = str(user_config_access.get('DEFAULT', 'search_engine'))
         self.opacity = float(user_config_access.get('DEFAULT', 'opacity'))
         self.show_corefour = int(user_config_access.get('DEFAULT', 'show_corefour'))
         self.corefour = eval(user_config_access.get('DEFAULT', 'corefour'))
         
         ie = InstalledEngines()
         if ie.is_valid(ie.read(), self.search_engine):
            pass
         else:
            self.search_engine = 'Google'
            
         corefour = []
         for c in self.corefour:
            if ie.is_valid(ie.read(), c):
               corefour.append(c)
            else:
               print "Unable to load %s" % c
         self.corefour = corefour
         
         user_config_file.close()
      except Exception, e:
         error()
         self.reset()
   
   def reset(self):
      user_config_file = open(self.SETTINGS_LOC, 'w')
      user_config_access = ConfigParser.RawConfigParser()
      
      user_config_access.set('DEFAULT', 'search_engine', 'Google')
      user_config_access.set('DEFAULT', 'opacity', 0.7)
      user_config_access.set('DEFAULT', 'show_corefour', 0)
      user_config_access.set('DEFAULT', 'corefour', ["Google", "Wikipedia", "Amazon"])

      user_config_access.write(user_config_file)
      user_config_file.close()
      
      self.search_engine = 'Google'
      self.opacity = 0.7
      self.show_corefour = 0
      self.corefour = ["Google", "Wikipedia", "Amazon"]
   
   def write(self):
      user_config_file = open(self.SETTINGS_LOC, 'w')
      user_config_access = ConfigParser.RawConfigParser()
      
      user_config_access.set('DEFAULT', 'search_engine', self.search_engine)
      user_config_access.set('DEFAULT', 'opacity', self.opacity)
      user_config_access.set('DEFAULT', 'show_corefour', self.show_corefour)
      user_config_access.set('DEFAULT', 'corefour', self.corefour)

      user_config_access.write(user_config_file)
      user_config_file.close()
   
   #-----------------------------------------------------------------
   #  All the accessor methods
   #-----------------------------------------------------------------
   
   def get_search_engine(self):
      return self.search_engine
      
   def get_opacity(self):
      return self.opacity
      
   def get_show_corefour(self):
      return self.show_corefour
   
   def get_corefour(self):
      return self.corefour
   
   #-----------------------------------------------------------------
   #  All the mutator methods
   #-----------------------------------------------------------------
   
   def set_search_engine(self, search_engine):
      self.search_engine = search_engine
      
   def set_opacity(self, opacity):
      self.opacity = opacity
      
   def set_show_corefour(self, show_corefour):
      self.show_corefour = show_corefour
      
   def set_corefour(self, corefour):
      self.corefour = corefour