#!/bin/sh

#    Copyright 2009, Brent Chiodo

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import ConfigParser
import subprocess
import osso

supports_alpha = False

HOME = os.getenv('HOME')

if not os.path.exists(HOME + "/.touchsearch/"):
   dir = '%s/.touchsearch/' % HOME
   os.mkdir(dir)
   

class Settings:
   def read(self):
      try:
         user_config_file = open(HOME + '/.touchsearch/settings.conf', 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)

         settings_dict = {}
         settings_dict['search_engine'] = user_config_access.get('DEFAULT', 'search_engine')
         settings_dict['icon_style'] = user_config_access.get('DEFAULT', 'icon_style')
         settings_dict['padding'] = int(user_config_access.get('DEFAULT', 'padding'))

         user_config_file.close()
      except Exception, e:
         # Settings file doesn't have the required option or doesn't exist

         print e
         self.write_defaults(None)
         settings_dict = self.read()

      return settings_dict

   def write(self, widget, search_engine=None, icon_style=None, padding=None):
      settings = self.read()
      user_config_file = open(HOME + '/.touchsearch/settings.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      if search_engine == None:
         user_config_access.set('DEFAULT', 'search_engine', settings['search_engine'])
      else:
         user_config_access.set('DEFAULT', 'search_engine', search_engine)
      if icon_style == None:
         user_config_access.set('DEFAULT', 'icon_style', settings['icon_style'])
      else:
         user_config_access.set('DEFAULT', 'icon_style', icon_style)
      if padding == None:
         user_config_access.set('DEFAULT', 'padding', settings['padding'])
      else:
         user_config_access.set('DEFAULT', 'padding', padding)

      user_config_access.write(user_config_file)
      user_config_file.close()

   def write_defaults(self, widget, data=None):
      user_config_file = open(HOME + '/.touchsearch/settings.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'search_engine', 'Google')
      user_config_access.set('DEFAULT', 'icon_style', '/usr/share/touchsearch/ghosted/')
      user_config_access.set('DEFAULT', 'padding', 10)

      user_config_access.write(user_config_file)
      user_config_file.close()


class TouchSearchHomePlugin(hildondesktop.HomePluginItem):

   def __init__(self):
      hildondesktop.HomePluginItem.__init__(self)
      self.set_settings(True)
      self.connect("show-settings", self.show_options)
      
      # Sets a suitable colormap to the screen
      screen = self.get_screen()
      colormap = screen.get_rgba_colormap()
      self.set_colormap(colormap)
      
      # Creates the main UI
      self.update_info()

#      self.connect("expose-event", self.expose)
#      self.connect("screen-changed", self.screen_changed)

   def update_info(self, widget=None):
      # Deinitialize images
      try:
         self.vbox.destroy()
         self.hbox.destroy()
         self.s_eventbox.destroy()
         self.e_eventbox.destroy()
      except Exception:
         pass # This is probably a first-run

      self.hbox = gtk.HBox()
      self.vbox = gtk.VBox()
      self.s_eventbox = gtk.EventBox()
      self.e_eventbox = gtk.EventBox()
      
      self.osso_context = osso.Context("org.maemo.touchsearch", "1.1", False)
      self.osso_rpc = osso.Rpc(self.osso_context)
      self.settings = Settings().read()
      self.image, self.url = self.get_data(self.settings['search_engine'])
      if self.settings['icon_style'].endswith('ghosted/'):
         self.select_icon = gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/touchsearch/select_search_engine_ghosted.png", 40, 40)
      else:
         self.select_icon = gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/touchsearch/select_search_engine_color.png", 40, 40)
      
      self.s_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
      self.s_eventbox.connect("button-press-event", self.search_dialog, self.osso_rpc)
      self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
      self.e_eventbox.connect("button-press-event", self.select_engine_dialog)

      self.hbox.pack_start(self.s_eventbox, False, False, self.settings['padding'])
      self.hbox.pack_end(self.e_eventbox, False, False, self.settings['padding'])
      self.vbox.pack_start(self.hbox, False, False, self.settings['padding'])
      self.vbox.show_all()
      
      self.s_eventbox.add(self.image)
      self.select_image = gtk.Image()
      self.select_image.set_from_pixbuf(self.select_icon)
      self.e_eventbox.add(self.select_image)
      self.vbox.show_all()
      self.add(self.vbox)
      
   def expose(self, widget, event):
      print 10
      cr = self.s_eventbox.window.cairo_create()
      cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent

      # Draw the background
      cr.set_operator(cairo.OPERATOR_SOURCE)
      cr.paint()

      # draw rounded rect
#      width, height = self.allocation[2], self.allocation[3]

      #/* a custom shape, that could be wrapped in a function */
#      x0 = 0   #/*< parameters like cairo_rectangle */
#      y0 = 0

#      radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */

#      x1 = x0 + width
#      y1 = y0 + height

#      cr.move_to  (x0, y0 + radius)
#      cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
#      cr.line_to (x1 - radius, y0)
#      cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
#      cr.line_to (x1 , y1 - radius)
#      cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
#      cr.line_to (x0 + radius, y1)
#      cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)

#      cr.close_path ()

#      bg_color=gtk.gdk.color_parse("#000000")

#      cr.set_source_rgba (bg_color.red / 65535.0, bg_color.green/65535.0, bg_color.blue/65535.0, float(32767/65535.0))
#      cr.fill_preserve ()
      # cr.set_source_rgba (0.5, 0.5, 1.0, 0.8)
      # cr.stroke ()
      
      return False

   def screen_changed(self, widget):
      screen = widget.get_screen()
      colormap = screen.get_rgba_colormap()
      widget.set_colormap(colormap)

      return False
      
   def show_options(self, widget):
      dialog = gtk.Dialog("TouchSearch Options", None, gtk.DIALOG_DESTROY_WITH_PARENT)
      
      #help_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      #help_button.set_text("Help", "Get help with how to use TouchSearch")
      #help_button.set_alignment(0,0,0,0)
      
      settings_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      settings_button.set_text("Settings", "Change how TouchSearch works")
      settings_button.set_alignment(0,0,0,0)
      settings_button.connect('clicked', self.show_settings)
      
      #configure_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      #configure_button.set_text("Configure", "Add/Edit/Delete search engines")
      #configure_button.set_alignment(0,0,0,0)
      
      about_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      about_button.set_text("About", "See Author, Copyright and License information")
      about_button.set_alignment(0,0,0,0)
      about_button.connect("clicked", self.show_about)
      
      #dialog.vbox.pack_start(help_button, True, True, 0)
      dialog.vbox.pack_start(settings_button, True, True, 0)
      #dialog.vbox.pack_start(configure_button, True, True, 0)
      dialog.vbox.pack_start(about_button, True, True, 0)
      
      dialog.show_all()
      dialog.run()
      dialog.destroy()
      
   def show_settings(self, widget):
      dialog = gtk.Dialog("Settings", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      
      ghosted_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, None)
      ghosted_button.set_label("Ghosted")
      ghosted_button.set_mode(False)
      color_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, ghosted_button)
      color_button.set_label("Color")
      color_button.set_mode(False)
      
      if self.settings['icon_style'].endswith('ghosted/'):
         ghosted_button.set_active(True)
      else:
         color_button.set_active(True)
      
      icon_hbox = gtk.HBox()
      icon_hbox.pack_end(ghosted_button, True, True, 0)
      icon_hbox.pack_end(color_button, True, True, 0)
      dialog.vbox.pack_start(gtk.Label("Icon Style"), False, False, 0)
      dialog.vbox.pack_start(icon_hbox, True, True, 10)
      dialog.show_all()
      response = dialog.run()
      
      if response == gtk.RESPONSE_OK:
         icon_buttons = ghosted_button.get_group()
         for button in icon_buttons:
            selected = button.get_active()
            if selected == True:
               label = button.get_label()
               if label == "Color":
                  path = "/usr/share/touchsearch/color/"
               else:
                  path = "/usr/share/touchsearch/ghosted/"
               break
         Settings().write(widget, None, path)
         self.update_info()

      dialog.destroy()
      
   def show_about(self, widget):
      dialog = gtk.AboutDialog()
      dialog.set_title("About")
      dialog.set_name("TouchSearch")
      dialog.set_version("1.3")
      dialog.set_copyright("Copyright 2009 Brent Chiodo")
      dialog.set_authors(["Brent Chiodo <bchiodo@gmail.com>"])
      dialog.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/touchsearch/icon.png"))
      dialog.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
      dialog.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public 
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")
      dialog.show_all()
      dialog.run()
      dialog.destroy()
      
   def on_picker_value_changed(self, widget, data):
      engine = widget.get_current_text()
      if engine == None:
         print "Dialog Destroyed. Returning..."
         return False
      else:
         Settings().write(widget, engine)
         self.update_info()

   def search_dialog(self, widget, event, osso_rpc):
      dialog = gtk.Dialog("Search for", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = dialog.add_button("Search", 1)

      image, url = self.get_data(self.settings['search_engine'])
      entry = hildon.Entry(0)

      hbox = gtk.HBox()
      hbox.pack_start(image, False, False, 5)
      hbox.pack_end(entry, True, True, 5)
      
      search_button.connect('clicked', self.search_the_web, entry, url, osso_rpc)
      entry.connect("key-press-event", self.key_pressed, dialog, entry, url, osso_rpc)
      dialog.vbox.pack_start(hbox)
      dialog.show_all()
      dialog.run()

      dialog.destroy()
      
   def select_engine_dialog(self, widget, data=None):
      dialog = hildon.PickerDialog(gtk.Window())
      dialog.set_title("Select Search Engine")
      
      selector = hildon.TouchSelector(text=True)
      searches = ["Google", "Wikipedia", "eBay", "IMDb", "Amazon", "General Shopping", "Dictionary.com", "Google Maps", "YouTube"]
      for i in searches:
         selector.append_text(i)
      selector.connect("changed", self.on_picker_value_changed)
      
      dialog.set_selector(selector)
      dialog.show_all()
      response = dialog.run()
      dialog.destroy()
      
   def search_the_web(self, widget, entry, url, osso_rpc):
      query = entry.get_text()
      url_scheme = url % query
      print url_scheme
      osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (url_scheme,))
      
   def key_pressed(self, widget, event, dialog, entry, url, osso_rpc, *args):
      if event.keyval == gtk.keysyms.KP_Enter:
         self.search_the_web(widget, entry, url, osso_rpc)
         dialog.destroy()
      else:
         return False

   def get_data(self, engine):
      d = self.settings['icon_style']
      if engine == "Google":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "google.png", 122, 40)
         url = "http://www.google.com/custom?hl=en&client=pub-2014082016242195&channel=3970614103&cof=FORID%%3A13%%3BAH%%3Aleft%%3BS%%3Ahttp%%3A%%2F%%2Fwww.google.com%%2Fcse%%3Fcx%%3D003942025946635967052%%253A4eq_cwvmcim%%26ie%%3DUTF-8%%26q%%3D%%26sa%%3DSearch%%3BCX%%3AWeb%%2520%%2528mobile-optimized%%2529%%3BL%%3Ahttp%%3A%%2F%%2Fwww.google.com%%2Fimages%%2Fgoogle_sm.gif%%3BLH%%3A59%%3BLP%%3A1%%3BVLC%%3A%%23551a8b%%3BGFNT%%3A%%23666666%%3BDIV%%3A%%23cccccc%%3B&adkw=AELymgXvPYDM4X5-BVw_BuVC9v6xuBytBCsp1DhSSByJlGcS0stpcK38sTNjYyfwouQDi7IW3HBDDErXgreOqmYQtxp2DU96bhRZ5Nyjxv8CHhWCKzlYWUc&btnG=Search&cx=partner-pub-2014082016242195&q=%s"
      elif engine == "Amazon":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "amazon.png", 122, 40)
         url = "http://www.amazon.com/s/ref=nb_ss?url=search-alias%%3Daps&field-keywords=%s&x=0&y=0"
      elif engine == "eBay":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "ebay.png", 122, 40)
         url = "http://shop.ebay.com/?_from=R40&_trksid=p3907.m38.l1313&_nkw=%s&=&_sacat=See-All-Categories"
      elif engine == "General Shopping":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "general_shopping.png", 122, 40)
         url = "http://www.google.com/cse?cx=003942025946635967052%%3Askvgvkrij3u&ie=UTF-8&q=%s&sa=Search"
      elif engine == "Dictionary.com":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "dictionary.png", 122, 40)
         url = "http://m.reference.com/d/search.html?q=%s"
      elif engine == "Google Maps":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "google_maps.png", 122, 40)
         #url = "http://maps.google.com/maps?hl=en&tab=wl&q=%s"
         url = "http://tomch.com/maemaps.html?from=%s&go=1"
      elif engine == "YouTube":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "youtube.png", 122, 40)
         url = "http://www.youtube.com/results?search_query=%s&search_type=&aq=f"
      elif engine == "IMDb":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "imdb.png", 122, 40)
         url = "http://www.imdb.com/find?s=all&q=%s"
      elif engine == "Wikipedia":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "wikipedia.png", 122, 40)
         url = "http://en.wikipedia.org/w/index.php?title=Special%%3ASearch&search=%s&fulltext=Search"
      image = gtk.Image()
      image.set_from_pixbuf(icon)
      image.set_padding(self.settings['padding'], self.settings['padding'])
      return (image, url)

hd_plugin_type = TouchSearchHomePlugin

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
