#!/bin/sh

#    Copyright 2009, Brent Chiodo

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import ConfigParser
import subprocess

supports_alpha = False

HOME = os.getenv('HOME')

if not os.path.exists(HOME + "/.touchsearch/"):
   dir = '%s/.touchsearch/' % HOME
   os.mkdir(dir)

class TouchSearchHomePlugin(hildondesktop.HomePluginItem):

   def __init__(self):
      hildondesktop.HomePluginItem.__init__(self)
      self.set_settings(True)
      self.connect("show-settings", self.show_settings)
      
      screen = self.get_screen()
      colormap = screen.get_rgba_colormap()
      self.set_colormap(colormap)

      settings = self.get_settings()
      self.image, url = self.get_data(settings['search_engine'])

      self.hbox = gtk.HBox()
      
      self.s_eventbox = gtk.EventBox()
      self.s_eventbox.add(self.image)
      self.s_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
      self.s_eventbox.connect("button-press-event", self.search_dialog)

      #self.select_button = gtk.Button()
      self.e_eventbox = gtk.EventBox()
      self.select_icon = gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/touchsearch/select_search_engine.png", 40, 40)
      self.select_image = gtk.Image()
      self.select_image.set_from_pixbuf(self.select_icon)
      #self.select_image.set_padding(settings['padding'], settings['padding'])
      #self.select_button.set_image(self.select_image)
      self.e_eventbox.add(self.select_image)
      self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
      self.e_eventbox.connect("button-press-event", self.select_engine_dialog)

      self.hbox.pack_start(self.s_eventbox, False, False, settings['padding'])
      self.hbox.pack_end(self.e_eventbox, False, False, settings['padding'])
      self.vbox = gtk.VBox()
      self.vbox.pack_start(self.hbox, False, False, settings['padding'])
      self.vbox.show_all()

      #self.connect("expose-event", self.screen_changed)
      self.add(self.vbox)
      self.connect("expose-event", self.expose)
      
   def expose(self, widget, event):
      cr = self.window.cairo_create()
      cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent

      # Draw the background
      cr.set_operator(cairo.OPERATOR_SOURCE)
      cr.paint()

      # draw rounded rect
      width, height = self.allocation[2], self.allocation[3]

      #/* a custom shape, that could be wrapped in a function */
      x0 = 0   #/*< parameters like cairo_rectangle */
      y0 = 0

      radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */

      x1 = x0 + width
      y1 = y0 + height

      cr.move_to  (x0, y0 + radius)
      cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
      cr.line_to (x1 - radius, y0)
      cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
      cr.line_to (x1 , y1 - radius)
      cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
      cr.line_to (x0 + radius, y1)
      cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)

      cr.close_path ()

      bg_color=gtk.gdk.color_parse("#000000")

      cr.set_source_rgba (bg_color.red / 65535.0, bg_color.green/65535.0, bg_color.blue/65535.0, float(32767/65535.0))
      cr.fill_preserve ()
      # cr.set_source_rgba (0.5, 0.5, 1.0, 0.8)
      # cr.stroke ()

   def screen_changed(self, widget):

      # To check if the display supports alpha channels, get the colormap
      screen = self.get_screen()
      colormap = screen.get_rgba_colormap()

      # Now we have a colormap appropriate for the screen, use it
      self.set_colormap(colormap)

      return False
      
   def show_settings(self, widget):
      dialog = gtk.Dialog("Configure TouchSearch", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      about_button = dialog.add_button("About", 2)
      about_button.connect('clicked', self.about_touchsearch)
      
      settings = self.get_settings()
      
      padding_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      padding_entry.set_max_length(2)
      padding_entry.set_text(str(settings['padding']))
      
      padding_hbox = gtk.HBox()
      padding_hbox.pack_start(gtk.Label("Button Size (Padding):"), False, False, 5)
      padding_hbox.pack_end(padding_entry, True, True, 5)
      
      ghosted_button = gtk.RadioButton(None, 'Ghosted')
      ghosted_button.set_mode(False)
      color_button = gtk.RadioButton(ghosted_button, 'Color')
      color_button.set_mode(False)
      color_button.set_sensitive(False)
      
      icon_hbox = gtk.HBox()
      icon_hbox.pack_start(gtk.Label("Icon Style:"), False, False, 5)
      icon_hbox.pack_end(ghosted_button, True, True, 0)
      icon_hbox.pack_end(color_button, True, True, 0)
      
      warning = gtk.Label()
      warning.set_use_markup(True)
      warning.set_label("<i>* Settings need applet restart to take effect</i>")
      
      dialog.vbox.pack_start(padding_hbox, True, True, 10)
      dialog.vbox.pack_start(icon_hbox, True, True, 10)
      dialog.vbox.pack_end(warning, False, False, 10)
      dialog.show_all()
      response = dialog.run()
      
      if response == gtk.RESPONSE_OK:
         padding = padding_entry.get_text()
         icon_buttons = ghosted_button.get_group()
         for button in icon_buttons:
            selected = button.get_active()
            if selected == True:
               label = button.get_label()
               if label == "Color":
                  path = "/usr/share/touchsearch/color/"
               else:
                  path = "/usr/share/touchsearch/ghosted/"
               break
         self.set_app_settings(widget, None, path, padding)

      dialog.destroy()
      
   def about_touchsearch(self, widget):
      dialog = gtk.AboutDialog()
      dialog.set_title("About TouchSearch")
      dialog.set_name("TouchSearch")
      dialog.set_version("1.1")
      dialog.set_copyright("Copyright 2009 Brent Chiodo")
      dialog.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
      dialog.show_all()
      dialog.run()
      dialog.destroy()
      
   def on_picker_value_changed(self, widget, data):
      engine = widget.get_current_text()
      print widget
      self.s_eventbox.remove(self.image)
      self.image, url = self.get_data(engine)
      self.s_eventbox.add(self.image)
      self.s_eventbox.show_all()
      self.set_app_settings(widget, engine)

   def search_dialog(self, widget, data=None):
      settings = self.get_settings()
      dialog = gtk.Dialog("Type A Search Query", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = dialog.add_button("Search", 1)

      image, url = self.get_data(settings['search_engine'])
      entry = gtk.Entry()

      hbox = gtk.HBox()
      hbox.pack_start(image, False, False, 5)
      hbox.pack_end(entry, True, True, 5)
      
      search_button.connect('clicked', self.search_the_web, entry, url)
      dialog.vbox.pack_start(hbox)
      dialog.show_all()
      dialog.run()

      dialog.destroy()
      
   def select_engine_dialog(self, widget, data=None):
      dialog = hildon.PickerDialog(gtk.Window())
      dialog.set_title("Select A Site To Search")
      
      selector = hildon.TouchSelector(text=True)
      searches = ["Google", "eBay", "General Shopping", "Dictionary.com", "Google Maps"]
      for i in searches:
         selector.append_text(i)
      selector.connect("changed", self.on_picker_value_changed)
      
      dialog.set_selector(selector)
      dialog.show_all()
      response = dialog.run()
      dialog.destroy()
      
   def search_the_web(self, widget, entry, url):
      query = entry.get_text()
      url_scheme = url % query
      print url_scheme
      call = 'dbus-send --system --type=method_call --dest="com.nokia.osso_browser" --print-reply /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:"%s"' % url_scheme
      subprocess.Popen(call, shell=True)

   def get_data(self, engine):
      settings = self.get_settings()
      d = settings['icon_style']
      if engine == "Google":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "google.png", 122, 40)
         url = "http://www.google.com/custom?hl=en&client=pub-2014082016242195&channel=8876981054&cof=FORID%%3A13%%3BAH%%3Aleft%%3BS%%3Ahttp%%3A%%2F%%2Fwww.google.com%%2Fcse%%3Fcx%%3D003942025946635967052%%253A4eq_cwvmcim%%26ie%%3DUTF-8%%26q%%3D%%26sa%%3DSearch%%3BCX%%3AWeb%%2520%%2528mobile-optimized%%2529%%3BL%%3Ahttp%%3A%%2F%%2Fwww.google.com%%2Fimages%%2Fgoogle_sm.gif%%3BLH%%3A59%%3BLP%%3A1%%3BVLC%%3A%%23551a8b%%3BGFNT%%3A%%23666666%%3BDIV%%3A%%23cccccc%%3B&adkw=AELymgXvPYDM4X5-BVw_BuVC9v6xuBytBCsp1DhSSByJlGcS0stpcK38sTNjYyfwouQDi7IW3HBDDErXgreOqmYQtxp2DU96bhRZ5Nyjxv8CHhWCKzlYWUc&btnG=Search&cx=partner-pub-2014082016242195&q=%s"
      elif engine == "eBay":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "ebay.png", 122, 40)
         url = "http://shop.ebay.com/?_from=R40&_trksid=p3907.m38.l1313&_nkw=%s&=&_sacat=See-All-Categories"
      elif engine == "General Shopping":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "general_shopping.png", 122, 40)
         url = "http://www.google.com/cse?cx=003942025946635967052%%3Askvgvkrij3u&ie=UTF-8&q=%s&sa=Search"
      elif engine == "Dictionary.com":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "dictionary.png", 122, 40)
         url = "http://m.reference.com/d/search.html?q=%s"
      elif engine == "Google Maps":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "google_maps.png", 122, 40)
         url = "http://maps.google.com/maps?hl=en&tab=wl&q=%s"
      image = gtk.Image()
      image.set_from_pixbuf(icon)
      image.set_padding(settings['padding'], settings['padding'])
      return (image, url)

   def get_settings(self):
      try:
         user_config_file = open(HOME + '/.touchsearch/settings.conf', 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)

         settings_dict = {}
         settings_dict['search_engine'] = user_config_access.get('DEFAULT', 'search_engine')
         settings_dict['icon_style'] = user_config_access.get('DEFAULT', 'icon_style')
         settings_dict['padding'] = int(user_config_access.get('DEFAULT', 'padding'))

         user_config_file.close()
      except Exception, e:
         # Settings file doesn't have the required option or doesn't exist

         print e
         self.set_default_settings(None)
         settings_dict = self.get_settings()

      return settings_dict

   def set_app_settings(self, widget, search_engine=None, icon_style=None, padding=None):
      settings = self.get_settings()
      user_config_file = open(HOME + '/.touchsearch/settings.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      if search_engine == None:
         user_config_access.set('DEFAULT', 'search_engine', settings['search_engine'])
      else:
         user_config_access.set('DEFAULT', 'search_engine', search_engine)
      if icon_style == None:
         user_config_access.set('DEFAULT', 'icon_style', settings['icon_style'])
      else:
         user_config_access.set('DEFAULT', 'icon_style', icon_style)
      if padding == None:
         user_config_access.set('DEFAULT', 'padding', settings['padding'])
      else:
         user_config_access.set('DEFAULT', 'padding', padding)

      user_config_access.write(user_config_file)
      user_config_file.close()

   def set_default_settings(self, widget, data=None):
      user_config_file = open(HOME + '/.touchsearch/settings.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'search_engine', 'Google')
      user_config_access.set('DEFAULT', 'icon_style', '/usr/share/touchsearch/ghosted/')
      user_config_access.set('DEFAULT', 'padding', 10)

      user_config_access.write(user_config_file)
      user_config_file.close()

hd_plugin_type = TouchSearchHomePlugin

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
