#include <QWidget>
#include <QMenu>
#include <QPixmap>
#include <QIcon>
#include <QToolBar>
#include <QApplication>
#include "mainwindowactions.h"


MainWindowActions::MainWindowActions(QObject* parent, bool repeat, bool shuffle)
{
    playAction = new QAction(QIcon (QPixmap (":images/play.png")), "", parent);
    playAction->setShortcut(playAction->tr("x"));
    playAction->setDisabled(true);
    pauseAction = new QAction(QIcon (QPixmap (":images/pause.png")), "", parent);
    pauseAction->setShortcut(pauseAction->tr("c"));
    pauseAction->setDisabled(true);
    pauseAction->setVisible(false);
    stopAction = new QAction(QIcon (QPixmap (":images/stop.png")), "", parent);
    stopAction->setShortcut(stopAction->tr("v"));
    stopAction->setDisabled(true);
    nextAction = new QAction(QIcon (QPixmap (":images/next.png")), "", parent);
    nextAction->setShortcut(nextAction->tr("b"));
    upAction = new QAction(QIcon (QPixmap (":images/up.png")), "", parent);
    upAction->setVisible(false);
    downAction = new QAction(QIcon (QPixmap (":images/down.png")), "", parent);
    downAction->setVisible(false);
    delAction = new QAction(QIcon (QPixmap (":images/remove.png")), "", parent);
    delAction->setVisible(false);
    addAction = new QAction(QIcon (QPixmap (":images/add.png")), "", parent);
    addAction->setVisible(false);
    enqueueActionButton = new QAction(QIcon (QPixmap (":images/enqueue.png")), "", parent);
    enqueueActionButton->setVisible(false);
    enqueueActionButton->setShortcut(enqueueActionButton->tr ("e"));
    previousAction = new QAction(QIcon (QPixmap (":images/previous.png")), "", parent);
    previousAction->setShortcut(previousAction->tr("z"));
    if (repeat)
        repeatAction = new QAction(QIcon (QPixmap (":images/repeat.png")), "", parent);
    else
        repeatAction = new QAction(QIcon (QPixmap (":images/repeat_disabled.png")), "", parent);
    repeatAction->setShortcut(repeatAction->tr("r"));
    if (shuffle)
        shuffleAction = new QAction(QIcon (QPixmap (":images/shuffle.png")), "", parent);
    else
        shuffleAction = new QAction(QIcon (QPixmap (":images/shuffle_disabled.png")), "", parent);
    shuffleAction->setShortcut(shuffleAction->tr("s"));
    volumeAction = new QAction(QIcon (QPixmap (":images/volume.png")), "", parent);
    volumeAction->setVisible(false);
    volumeAction->setCheckable(true);
    toggleControls = new QAction(QIcon (QPixmap (":images/arrow1.png")), "", parent);
    addFilesAction = new QAction(addFilesAction->tr("Add &File"), parent);
    addFilesAction->setShortcut(addFilesAction->tr("a"));
    addFoldersAction = new QAction(addFoldersAction->tr("Add F&older"), parent);
    addFoldersAction->setShortcut(addFoldersAction->tr("f"));
    addUrlAction = new QAction(addUrlAction->tr("Add &Url"), parent);
    addUrlAction->setShortcut(addUrlAction->tr("u"));
    savePlaylistAction = new QAction (savePlaylistAction->tr("Sa&ve Playlist"), parent);
    savePlaylistAction->setShortcut(savePlaylistAction->tr ("Ctrl+V"));
    loadPlaylistAction = new QAction (loadPlaylistAction->tr("&Load Playlist"), parent);
    loadPlaylistAction->setShortcut(loadPlaylistAction->tr("Ctrl+L"));
    clearPlaylistAction = new QAction (clearPlaylistAction->tr("&Clear Playlist"), parent);
    clearPlaylistAction->setShortcut(clearPlaylistAction->tr("Ctrl+C"));
    optionAction = new QAction (optionAction->tr("Op&tions"), parent);
    optionAction->setShortcut(optionAction->tr("o"));
    equalizerAction = new QAction (equalizerAction->tr("&Equalizer"), parent);
    equalizerAction->setShortcut(equalizerAction->tr("q"));
    exitAction = new QAction(exitAction->tr("E&xit"), parent);
    exitAction->setShortcut(exitAction->tr("Ctrl+X"));
    aboutAction = new QAction(aboutAction->tr("A&bout"), parent);
    aboutAction->setShortcut(aboutAction->tr("Ctrl+B"));
    aboutQtAction = new QAction(aboutQtAction->tr("About &Qt"), parent);
    aboutQtAction->setShortcut(aboutQtAction->tr("Ctrl+Q"));

    parent->connect(playAction, SIGNAL(triggered()), SLOT(play()));
    parent->connect(pauseAction, SIGNAL(triggered()), SLOT(pause()) );
    parent->connect(stopAction, SIGNAL(triggered()), SLOT(stop()));
    parent->connect(repeatAction, SIGNAL(triggered()), SLOT(repeatToggle()));
    parent->connect(shuffleAction, SIGNAL(triggered()), SLOT(shuffleToggle()));
    parent->connect(volumeAction, SIGNAL(triggered()), SLOT(volumeToggle()));
    parent->connect(enqueueActionButton, SIGNAL(triggered()), SLOT(enqueueSelected()));
    parent->connect (addAction, SIGNAL(triggered()), SLOT(showAddMenu()));
    parent->connect(toggleControls, SIGNAL(triggered()), SLOT(controlsToggled()));

    parent->connect(addFilesAction, SIGNAL(triggered()), SLOT(addFiles()));
    parent->connect(addFoldersAction, SIGNAL(triggered()), SLOT(addFolder()));
    parent->connect(addUrlAction, SIGNAL(triggered()), SLOT(addUrl()));
    parent->connect (savePlaylistAction, SIGNAL (triggered()), SLOT (savePlaylist()));
    parent->connect (loadPlaylistAction, SIGNAL (triggered()), SLOT (loadPlaylist()));
    parent->connect (clearPlaylistAction, SIGNAL (triggered()), SLOT (clearPlaylist()));
    parent->connect (optionAction, SIGNAL (triggered()), SLOT (showOptions()));
    parent->connect (equalizerAction, SIGNAL (triggered()), SLOT (showEqualizer()));
    parent->connect (nextAction, SIGNAL(triggered()), SLOT(next()));
    parent->connect (previousAction, SIGNAL(triggered()), SLOT(previous()));
    parent->connect (upAction, SIGNAL(triggered()), SLOT(upSelected()));
    parent->connect (downAction, SIGNAL(triggered()), SLOT(downSelected()));
    parent->connect (delAction, SIGNAL(triggered()), SLOT(removeSelectedItem()));
    parent->connect(exitAction, SIGNAL(triggered()), SLOT(close()));
    parent->connect(aboutAction, SIGNAL(triggered()), SLOT(about()));
    parent->connect(aboutQtAction, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
}

void MainWindowActions::playingState ()
{
    if (stopAction->isVisible())
    {            
        pauseAction->setVisible(true);
        playAction->setVisible (false);
    }
    playAction->setEnabled(false);
    pauseAction->setEnabled(true);
    stopAction->setEnabled(true);
}

void MainWindowActions::stoppedState ()
{
    stopAction->setEnabled(false);
    playAction->setEnabled(true);
    if (stopAction->isVisible())
    {            
        pauseAction->setVisible(false);
        playAction->setVisible(true);
    }
    pauseAction->setEnabled(false);
}

void MainWindowActions::pausedState ()
{
    pauseAction->setEnabled(false);
    stopAction->setEnabled(true);
    if (stopAction->isVisible())
    {            
        pauseAction->setVisible(false);
        playAction->setVisible(true);
    }
    playAction->setEnabled(true);
}

void MainWindowActions::repeatToggle(bool repeat)
{
    if (repeat)
        repeatAction->setIcon(QIcon (QPixmap (":images/repeat.png")));
    else
        repeatAction->setIcon(QIcon (QPixmap (":images/repeat_disabled.png")));
    
}

void MainWindowActions::shuffleToggle(bool shuffle)
{
    if (shuffle)
        shuffleAction->setIcon(QIcon (QPixmap (":images/shuffle.png")));
    else
        shuffleAction->setIcon(QIcon (QPixmap (":images/shuffle_disabled.png")));
}


void MainWindowActions::setupMenus (QMenu* fileMenu, QMenu* aboutMenu)
{
    fileMenu->addAction(addFilesAction);
    fileMenu->addAction(addFoldersAction);
    fileMenu->addAction(addUrlAction);
    fileMenu->addSeparator();
    fileMenu->addAction(savePlaylistAction);
    fileMenu->addAction(loadPlaylistAction);
    fileMenu->addAction(clearPlaylistAction);
    fileMenu->addAction(optionAction);
    fileMenu->addAction(equalizerAction);
    aboutMenu->addAction(aboutAction);
    aboutMenu->addAction(aboutQtAction);
}

void MainWindowActions::setupToolbar(QToolBar *bar)
{
    bar->addAction(previousAction);
    bar->addAction(playAction);
    bar->addAction(pauseAction);
    bar->addAction(stopAction);
    bar->addAction(nextAction);
    bar->addAction(repeatAction);
    bar->addAction(shuffleAction);
    bar->addAction(upAction);
    bar->addAction(downAction);
    bar->addAction(delAction);
    bar->addAction(addAction);
    bar->addAction(enqueueActionButton);
    bar->addAction(volumeAction);
    bar->addAction(toggleControls);
}

void MainWindowActions::setupContextAndAddMenu (QMenu* contextMenu, QMenu* addMenu, QObject* parent)
{
    enqueueAction = contextMenu->addAction(contextMenu->tr ("Enqueue"));
    removeSelected = contextMenu->addAction(contextMenu->tr ("Remove selected"));
    removeAllButSelected = contextMenu->addAction(contextMenu->tr("Remove all but selected"));
    parent->connect (removeSelected, SIGNAL (triggered()), SLOT (removeSelectedItem()));
    parent->connect (removeAllButSelected, SIGNAL (triggered()), SLOT (removeAllButSelectedItem()));
    parent->connect (enqueueAction, SIGNAL (triggered()), SLOT (enqueueSelected()));
    addMenuAddFile = addMenu->addAction(addMenu->tr ("Add File"));
    addMenuAddUrl = addMenu->addAction(addMenu->tr ("Add Url"));
    addMenuAddFolder = addMenu->addAction(addMenu->tr ("Add Folder"));
    parent->connect (addMenuAddFile, SIGNAL(triggered()), SLOT(addFiles()));
    parent->connect (addMenuAddUrl, SIGNAL(triggered()), SLOT(addUrl()));
    parent->connect (addMenuAddFolder, SIGNAL(triggered()), SLOT(addFolder()));
}

void MainWindowActions::controlsToggled (bool playing)
{
    if (stopAction->isVisible())
    {
        playAction->setVisible(false);
        pauseAction->setVisible(false);
        stopAction->setVisible(false);
        nextAction->setVisible(false);
        previousAction->setVisible(false);
        shuffleAction->setVisible(false);
        repeatAction->setVisible(false);
        upAction->setVisible(true);
        downAction->setVisible(true);
        delAction->setVisible(true);
        addAction->setVisible(true);
        enqueueActionButton->setVisible(true);
        volumeAction->setVisible(true);
        toggleControls->setIcon(QIcon (QPixmap (":images/arrow2.png")));
    }
    else
    {
        if (playing)
            pauseAction->setVisible(true);
        else
            playAction->setVisible(true);
        stopAction->setVisible(true);
        nextAction->setVisible(true);
        previousAction->setVisible(true);
        shuffleAction->setVisible(true);
        repeatAction->setVisible(true);
        upAction->setVisible(false);
        downAction->setVisible(false);
        delAction->setVisible(false);
        addAction->setVisible(false);
        enqueueActionButton->setVisible(false);
        volumeAction->setVisible(false);
        toggleControls->setIcon(QIcon (QPixmap (":images/arrow1.png")));
    }
}
