#include <QHBoxLayout>
#include <QtDebug>
#include "equalizerdialog.h"

EqualizerDialog::EqualizerDialog(QWidget *parent, QList<int> vals, int sliderCount, int min, int max) :
    QDialog(parent)
{
    QHBoxLayout* l = new QHBoxLayout;
    for (int i = 0; i < sliderCount; ++i)
    {
        QSlider* s = new QSlider (Qt::Vertical);
        s->setMinimum(min);
        s->setMaximum(max);
        s->setMinimumHeight(300);
        if (vals.size() > i)
            s->setValue(vals[i]);
        connect (s, SIGNAL(valueChanged(int)), this, SLOT(sliderChanged(int)));
        l->addWidget(s);
        sliders.append(s);
    }
    setLayout(l);
    setWindowTitle(tr ("TomAmp Equalizer"));
}

void EqualizerDialog::sliderChanged (int val)
{
    QSlider* s = qobject_cast<QSlider*>(sender ());
    if (s)
    {
        int ind = sliders.indexOf(s);
        emit equalizerChanged(ind, val);
    }
}


