#ifndef VALUEDIALOG_H
#define VALUEDIALOG_H

#include <QDialog>

class QListView;
class QModelIndex;
class SelectionModel;

class ValueDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ValueDialog(QWidget *parent = 0);
    ~ValueDialog();

    SelectionModel* model() const;
    virtual void setModel(SelectionModel *model);

    QVariant currentValue();
    virtual void setValue(const QVariant &value);
    
protected slots:
    virtual void onItemClicked(const QModelIndex &index);
    
signals:
    void valueChanged(const QVariant &value);

protected:
    SelectionModel *m_model;
    QListView *m_view;
};

#endif // VALUEDIALOG_H
