#ifndef SONGLISTWINDOW_H
#define SONGLISTWINDOW_H

#include "stackedwindow.h"
#include "song.h"

using namespace QtUbuntuOne;

class SongModel;
class ListView;
class QAction;
class QLabel;
class QModelIndex;

class SongListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit SongListWindow(QWidget *parent = 0);

    void getSongs();

private:
    void showEvent(QShowEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void showContextMenu(const QPoint &pos);
    void queueSong();
    void onItemClicked(const QModelIndex &index);
    void playSong(const QModelIndex &index);

private:
    ListView *m_view;
    SongModel *m_model;

    QMenu *m_contextMenu;
    QAction *m_addToQueueContextAction;

    QLabel *m_noResultsLabel;
};

#endif // SONGLISTWINDOW_H
