#ifndef PLAYLISTSONGSWINDOW_H
#define PLAYLISTSONGSWINDOW_H

#include "stackedwindow.h"
#include "playlist.h"
#include "song.h"

using namespace QtUbuntuOne;

class SongModel;
class ListView;
class ArtworkLabel;
class SeparatorLabel;
class ScrollArea;
class QAction;
class QLabel;
class QPushButton;
class QModelIndex;
class ArtworkCache;

class PlaylistSongsWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit PlaylistSongsWindow(Playlist *playlist, QWidget *parent = 0);

private:
    void showEvent(QShowEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void showContextMenu(const QPoint &pos);
    void queueSong();
    void onItemClicked(const QModelIndex &index);
    void playSong(const QModelIndex &index);
    void playPlaylist();
    void setArtwork();

private:
    Playlist *m_playlist;
    ListView *m_view;
    SongModel *m_model;

    ArtworkCache *m_cache;

    QMenu *m_contextMenu;
    QAction *m_addToQueueContextAction;

    QLabel *m_titleLabel;

    ArtworkLabel *m_artwork;

    QPushButton *m_playButton;

    SeparatorLabel *m_separator;

    ScrollArea *m_scrollArea;
};

#endif // PLAYLISTSONGSWINDOW_H
