#include "musictab.h"
#include "listview.h"
#include "musiclistdelegate.h"
#include "windowstack.h"
#include "artistlistwindow.h"
#include "albumlistwindow.h"
#include "songlistwindow.h"
#include "playlistlistwindow.h"
#include "../shared/musicmodel.h"
#include <QListView>
#include <QGridLayout>

MusicTab::MusicTab(QWidget *parent) :
    AbstractTab(parent),
    m_model(new MusicModel(this)),
    m_view(new ListView(this)),
    m_grid(new QGridLayout(this))
{
    m_view->setModel(m_model);
    m_view->setItemDelegate(new MusicListDelegate(m_view));

    m_grid->setContentsMargins(11, 11, 11, 11);
    m_grid->addWidget(m_view);

    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

void MusicTab::onItemClicked(const QModelIndex &index) {
    switch (index.row()) {
    case 0:
        this->showArtists();
        return;
    case 1:
        this->showAlbums();
        return;
    case 2:
        this->showSongs();
        return;
    case 3:
        this->showPlaylists();
        return;
    default:
        return;
    }
}

void MusicTab::showArtists() {
    ArtistListWindow *window = new ArtistListWindow(WindowStack::instance()->currentWindow());
    window->show();
    window->getArtists();
}

void MusicTab::showAlbums() {
    AlbumListWindow *window = new AlbumListWindow(WindowStack::instance()->currentWindow());
    window->show();
    window->getAlbums();
}

void MusicTab::showSongs() {
    SongListWindow *window = new SongListWindow(WindowStack::instance()->currentWindow());
    window->show();
    window->getSongs();
}

void MusicTab::showPlaylists() {
    PlaylistListWindow *window = new PlaylistListWindow(WindowStack::instance()->currentWindow());
    window->show();
    window->getPlaylists();
}
