#ifndef ALBUMMODEL_H
#define ALBUMMODEL_H

#include "albumlist.h"
#include <QAbstractListModel>

using namespace QtUbuntuOne;

class ArtworkCache;

class AlbumRoles : public QObject
{
    Q_OBJECT

    Q_ENUMS(Role)

public:
    enum Role {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        ArtistIdRole,
        UrlRole,
        ArtworkUrlRole,
        ArtworkRole,
        YearRole,
        DateRole
    };
};

class AlbumModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QList<Album*> albums
               READ albums)

public:
    explicit AlbumModel(QObject *parent = 0);
    ~AlbumModel();
    
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, int role) const;

    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, int role);

    QMap<int, QVariant> itemData(const QModelIndex &index) const;
    Q_INVOKABLE QMap<int, QVariant> itemData(int row) const;

    Album* get(const QModelIndex &index) const;
    Q_INVOKABLE Album* get(int row) const;

    bool loading() const;

    QList<Album*> albums() const;

public slots:
    void getAlbums();
    void getArtistAlbums(const QString &artistId);

    void reload();
    void clear();

private:
    void setLoading(bool loading);

    QString artistId() const;
    void setArtistId(const QString &id);

    void appendAlbum(Album *album);
    void appendAlbums(QList<Album*> albums);

    void insertAlbum(int i, Album *album);
    void insertAlbums(int i, QList<Album*> albums);

    void removeAlbum(int i);
    void removeAlbums(int i, int count);

private slots:
    void addAlbums(AlbumList *list);
    void onArtworkReady();

signals:
    void countChanged(int count);
    void loadingChanged(bool loading);

private:
    ArtworkCache *m_cache;

    QList<Album*> m_list;

    bool m_loading;

    QString m_artistId;

    QHash<int, QByteArray> m_roleNames;
};

#endif // ALBUMMODEL_H
