#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"

class QLineEdit;
class QCheckBox;
class QMaemo5ValueButton;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;
class ValueSelector;

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showFileDialog();
    void loadSettings();
    void saveSettings();
    
private:
    QCheckBox *m_downloadCheckbox;
    QMaemo5ValueButton *m_downloadPathButton;

    QCheckBox *m_musicCacheCheckbox;

    ValueSelector *m_orientationSelector;
    ValueSelector *m_languageSelector;

    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;

    QScrollArea *m_scrollArea;

    QGridLayout *m_grid;

    QString m_downloadPath;
};

#endif // SETTINGSDIALOG_H
