#include "folderlistdialog.h"
#include "../shared/selectionmodel.h"
#include "../shared/nodemodel.h"
#include "textlistdelegate.h"
#include <QListView>
#include <QGridLayout>

FolderListDialog::FolderListDialog(const QModelIndex &index, QWidget *parent) :
    AbstractDialog(parent),
    m_model(new SelectionModel(this)),
    m_view(new QListView(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Choose folder"));

    m_grid->setContentsMargins(0, 0, 0 ,0);
    m_grid->addWidget(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new TextListDelegate(SelectionRoles::NameRole, Qt::AlignCenter, m_view));

    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    this->setCurrentIndex(index);
    this->onOrientationChanged();
}

void FolderListDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
}

void FolderListDialog::setPortraitLayout() {
    this->setFixedHeight(600);
}

void FolderListDialog::setCurrentIndex(QModelIndex index) {
    while (index.isValid()) {
        switch (index.data(NodeRoles::NodeTypeRole).toInt()) {
        case Node::Volume:
            m_model->addItem(index.data(NodeRoles::NodePathRole).toString(), "");
            break;
        default:
            m_model->addItem(index.data(NodeRoles::ResourcePathRole).toString(), "");
            break;
        }

        index = index.parent();
    }

    m_model->addItem("/", "");
    m_view->setCurrentIndex(m_model->index(0, 0));
}

void FolderListDialog::onItemClicked(const QModelIndex &index) {
    emit folderChosen(index.data(SelectionRoles::NameRole).toString());
    this->accept();
}
