#ifndef FILEDETAILSDIALOG_H
#define FILEDETAILSDIALOG_H

#include "abstractdialog.h"
#include <QModelIndex>

class QLineEdit;
class QLabel;
class QGridLayout;

class FileDetailsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FileDetailsDialog(const QModelIndex &file, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void loadFileData();
    void openLink(const QString &link);
    void onFileNameChanged(const QString &name);
    void renameFile();
    void deleteFile();
    void toggleFilePublished();

private:
    const QModelIndex m_file;

    QLineEdit *m_nameEdit;

    QLabel *m_createdLabel;
    QLabel *m_modifiedLabel;
    QLabel *m_publicUrlLabel;
    QLabel *m_sizeLabel;

    QPushButton *m_publishButton;
    QPushButton *m_renameButton;
    QPushButton *m_deleteButton;

    QGridLayout *m_grid;
};

#endif // FILEDETAILSDIALOG_H
