import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MySheet {
    id: root

    property alias name: nameEdit.text

    rejectButtonText: qsTr("Cancel")
    acceptButtonText: (nameEdit.acceptableInput) && (nameEdit.text !== nodeModel.data(view.selectedIndex, "name")) ? qsTr("Done") : ""
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors.fill: parent
            contentHeight: column.height + UI.PADDING_DOUBLE * 2

            Column {
                id: column

                anchors {
                    left: parent.left
                    right: parent.right
                    top: parent.top
                    margins: UI.PADDING_DOUBLE * 2
                }
                spacing: UI.PADDING_DOUBLE * 2

                Label {
                    width: parent.width
                    text: qsTr("New name")
                }

                MyTextField {
                    id: nameEdit

                    width: parent.width
                    inputMethodHints: Qt.ImhNoAutoUppercase | Qt.ImhNoPredictiveText
                    validator: RegExpValidator {
                        regExp: /[^//]+/
                    }
                    onAccepted: root.accept()
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }
}
