import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Dialog {
    id: root

    function displayInfo(info) {
        root.state = "info";
        infoLabel.text = info;
        root.open();
    }

    function displayError(errorString) {
        root.state = "error";
        infoLabel.text = errorString;
        root.open();
    }

    content: Item {
        height: column.height
        anchors {
            left: parent.left
            right: parent.right
        }

        Column {
            id: column

            anchors {
                left: parent.left
                right: parent.right
                top: parent.top
            }
            spacing: UI.PADDING_DOUBLE

            Image {
                id: icon

                x: Math.floor((parent.width / 2) - (width / 2))
            }

            Label {
                id: infoLabel

                width: parent.width
                horizontalAlignment: Text.AlignHCenter
                color: UI.COLOR_INVERTED_FOREGROUND
            }
        }
    }

    states: [
        State {
            name: "info"
            PropertyChanges { target: icon; source: "image://theme/icon-l-user-guide" }
        },

        State {
            name: "error"
            PropertyChanges { target: icon; source: "image://theme/icon-l-error" }
        }
    ]
}
