#ifndef ARTWORKCACHE_H
#define ARTWORKCACHE_H

#include "artwork.h"
#include <QObject>
#include <QQueue>

using namespace QtUbuntuOne;

class ArtworkCache : public QObject
{
    Q_OBJECT

public:
    explicit ArtworkCache(QObject *parent);
    ~ArtworkCache();

    Q_INVOKABLE QImage artwork(const QUrl &url, const QSize &size);

    Q_INVOKABLE void insert(const QUrl &url, const QImage &image);
    Q_INVOKABLE void remove(const QUrl &url, const QSize &size);
    Q_INVOKABLE void remove(const QImage &image);
    Q_INVOKABLE void clear();

private:
    QString id(const QUrl &url, const QSize &size) const;

    void processNextRequest();

private slots:
    void onArtworkReady(Artwork *artwork);

signals:
    void artworkReady();

private:
    static QHash<QString, QImage> m_cache;

    struct ArtworkRequest {
        QUrl url;
        QSize size;
    };

    QQueue<ArtworkRequest> m_queue;
};

#endif // ARTWORKCACHE_H
