#ifndef ARTISTMODEL_H
#define ARTISTMODEL_H

#include "artistlist.h"
#include <QAbstractListModel>

using namespace QtUbuntuOne;

class ArtworkCache;

class ArtistRoles : public QObject
{
    Q_OBJECT

    Q_ENUMS(Role)

public:
    enum Role {
        IdRole = Qt::UserRole + 1,
        NameRole,
        UrlRole,
        ArtworkUrlRole,
        ArtworkRole,
        SongCountRole,
        AlbumIdsRole
    };
};

class ArtistModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QList<Artist*> artists
               READ artists)

public:
    explicit ArtistModel(QObject *parent = 0);
    ~ArtistModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, int role) const;

    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, int role);

    QMap<int, QVariant> itemData(const QModelIndex &index) const;
    Q_INVOKABLE QMap<int, QVariant> itemData(int row) const;

    Artist* get(const QModelIndex &index) const;
    Q_INVOKABLE Artist* get(int row) const;

    bool loading() const;

    QList<Artist*> artists() const;

public slots:
    void getArtists();

    void reload();
    void clear();

private:
    void setLoading(bool loading);

    bool moreResults() const;
    void setMoreResults(bool more);

    void appendArtist(Artist *artist);
    void appendArtists(QList<Artist*> artists);

    void insertArtist(int i, Artist *artist);
    void insertArtists(int i, QList<Artist*> artists);

    void removeArtist(int i);
    void removeArtists(int i, int count);

private slots:
    void addArtists(ArtistList *list);
    void onArtworkReady();

signals:
    void countChanged(int count);
    void loadingChanged(bool loading);

private:
    ArtworkCache *m_cache;

    QList<Artist*> m_list;

    bool m_loading;

    QHash<int, QByteArray> m_roleNames;
};

#endif // ARTISTMODEL_H
