#include "playlistlistwindow.h"
#include "playlistsongswindow.h"
#include "playlistdelegate.h"
#include "listview.h"
#include "nowplayingbutton.h"
#include "../shared/playlistmodel.h"
#include <QLabel>
#include <QMaemo5Style>

PlaylistListWindow::PlaylistListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_view(new ListView(this)),
    m_model(new PlaylistModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this))
{
    this->setWindowTitle(tr("Playlists"));
    this->setCentralWidget(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new PlaylistDelegate(m_view));
    m_view->setMonitorScrolling(true);
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_view, SIGNAL(scrollingStarted()), NowPlayingButton::instance(), SLOT(hide()));
    this->connect(m_view, SIGNAL(scrollingStopped()), NowPlayingButton::instance(), SLOT(poke()));

    this->onOrientationChanged();
}

void PlaylistListWindow::showEvent(QShowEvent *event) {
    this->onLoadingChanged(m_model->loading());
    StackedWindow::showEvent(event);
}

void PlaylistListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void PlaylistListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void PlaylistListWindow::getPlaylists() {
    m_model->getPlaylists();
}

void PlaylistListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void PlaylistListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void PlaylistListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index));
    }
}

void PlaylistListWindow::showPlaylist(Playlist *playlist) {
    PlaylistSongsWindow *window = new PlaylistSongsWindow(playlist, this);
    window->show();
}
