#include "nowplayingdelegate.h"
#include "../shared/playbackqueuemodel.h"
#include "../shared/utils.h"
#include <QPainter>
#include <QStaticText>
#include <QMaemo5Style>

NowPlayingDelegate::NowPlayingDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void NowPlayingDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QStaticText durationText(Utils::durationFromSecs(index.data(SongRoles::DurationRole).toLongLong()));
    painter->drawStaticText(option.rect.right() - durationText.size().width() - 8, option.rect.top() + 8, durationText);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(textRect.left() + 8, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - durationText.size().width() - 24);

    painter->drawText(textRect, Qt::AlignTop | Qt::TextSingleLine, index.data(SongRoles::TitleRole).toString());

    textRect.moveTop(textRect.bottom());
    textRect.setRight(option.rect.right() - 8);

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, index.data(SongRoles::ArtistRole).toString());
    painter->restore();
}

QSize NowPlayingDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
