#ifndef ALBUMSONGSWINDOW_H
#define ALBUMSONGSWINDOW_H

#include "stackedwindow.h"
#include "album.h"
#include "song.h"

using namespace QtUbuntuOne;

class SongModel;
class ListView;
class ArtworkLabel;
class SeparatorLabel;
class ScrollArea;
class QAction;
class QLabel;
class QPushButton;
class QModelIndex;
class ArtworkCache;

class AlbumSongsWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit AlbumSongsWindow(Album *album, QWidget *parent = 0);

private:
    void showEvent(QShowEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void showContextMenu(const QPoint &pos);
    void queueSong();
    void onItemClicked(const QModelIndex &index);
    void playSong(const QModelIndex &index);
    void playAlbum();
    void setArtwork();

private:
    Album *m_album;
    ListView *m_view;
    SongModel *m_model;

    ArtworkCache *m_cache;

    QMenu *m_contextMenu;
    QAction *m_addToQueueContextAction;

    QLabel *m_titleLabel;

    ArtworkLabel *m_artwork;

    QPushButton *m_playButton;

    SeparatorLabel *m_separator;

    ScrollArea *m_scrollArea;
};

#endif // ALBUMSONGSWINDOW_H
