#ifndef ACCOUNTDIALOG_H
#define ACCOUNTDIALOG_H

#include "abstractdialog.h"
#include "useraccount.h"
#include "reply.h"

class QLabel;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;

using namespace QtUbuntuOne;

class AccountDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit AccountDialog(QWidget *parent = 0);

    void getAccount();
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onReplyFinished(Reply *reply);
    void onUserAccountReady(UserAccount *account);
    void signOut();

private:
    QLabel *m_usedBytesLabel;
    QLabel *m_totalBytesLabel;
    QLabel *m_planLabel;

    QDialogButtonBox *m_buttonBox;
    QPushButton *m_button;

    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // ACCOUNTDIALOG_H
