#ifndef UPLOADDIALOG_H
#define UPLOADDIALOG_H

#include "abstractdialog.h"

class FolderSelectionDialog;
class QMaemo5ValueButton;
class QCheckBox;
class QGridLayout;
class QDialogButtonBox;
class QModelIndex;

class UploadDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit UploadDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showFolderDialog();
    void setFolder(const QModelIndex &index);
    void showFileDialog();
    void uploadFile();
    
private:
    FolderSelectionDialog *m_folderDialog;

    QMaemo5ValueButton *m_folderButton;
    QMaemo5ValueButton *m_fileButton;

    QCheckBox *m_publicCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;

    QGridLayout *m_grid;

    QString m_contentPath;
    QString m_filePath;
};

#endif // UPLOADDIALOG_H
