#ifndef FOLDERLISTDIALOG_H
#define FOLDERLISTDIALOG_H

#include "abstractdialog.h"
#include <QModelIndex>

class SelectionModel;
class QListView;
class QGridLayout;

class FolderListDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FolderListDialog(const QModelIndex &index = QModelIndex(), QWidget *parent = 0);

    void setCurrentIndex(QModelIndex index);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void folderChosen(const QString &resourcePath);

private:
    SelectionModel *m_model;
    QListView *m_view;

    QGridLayout *m_grid;
};

#endif // FOLDERLISTDIALOG_H
