#ifndef FILESWINDOW_H
#define FILESWINDOW_H

#include "stackedwindow.h"
#include "listview.h"
#include <QMaemo5ValueButton>
#include <QPushButton>
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QLineEdit>
#include <QGridLayout>
#include <QKeyEvent>

class FilesWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit FilesWindow(QWidget *parent = 0);
    void setLandscapeLayout();
    void setPortraitLayout();

protected:
    void keyPressEvent(QKeyEvent *event);

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onRootIndexChanged(const QModelIndex &index);
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void moveUp();
    void goHome();
    void showFolderList();
    void setRootIndexFromResourcePath(const QString &resourcePath);
    void moveFiles();
    void deleteFiles();
    void downloadFiles();
    void refreshFolder();
    void showNewFolderDialog();
    void createNewFolder(const QString &name);
    void showUploadDialog();
    void showSettingsDialog();
    void showAboutDialog();
    void openFile();
    void showMoveFileDialog();
    void moveFile(const QModelIndex &destination);
    void showRenameDialog();
    void renameFile(const QString &name);
    void showConfirmDeleteDialog();
    void deleteFile();
    void downloadFile();
    void toggleFilePublished();
    void showTransfers();
    void onTransferCountChanged(int count);
    
private:
    ListView *m_listView;
    QAction *m_uploadAction;
    QAction *m_refreshAction;
    QAction *m_newFolderAction;
    QAction *m_moveAction;
    QAction *m_deleteAction;
    QAction *m_downloadAction;
    QAction *m_transfersAction;
    QAction *m_settingsAction;
    QAction *m_aboutAction;
    QMenu *m_contextMenu;
    QAction *m_openContextAction;
    QAction *m_moveContextAction;
    QAction *m_renameContextAction;
    QAction *m_deleteContextAction;
    QAction *m_downloadContextAction;
    QAction *m_publishContextAction;
    QPushButton *m_upButton;
    QPushButton *m_homeButton;
    QMaemo5ValueButton *m_folderButton;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // FILESWINDOW_H
