#include "filehandlersdialog.h"
#include "separatorlabel.h"

FileHandlersDialog::FileHandlersDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_handlersEdit(new QTextEdit(this)),
    m_suffixEdit(new QLineEdit(this)),
    m_commandEdit(new QLineEdit(this)),
    m_addButton(new QPushButton(tr("Add"), this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("File handlers"));
    onFileHandlersChanged(m_session->settings()->fileHandlers());
    onOrientationChanged();

    m_suffixEdit->setFixedWidth(150);
    m_handlersEdit->setReadOnly(true);
    m_addButton->setMinimumWidth(150);
    m_addButton->setEnabled(false);

    connect(m_session->settings(), SIGNAL(fileHandlersChanged(QVariantMap)), this, SLOT(onFileHandlersChanged(QVariantMap)));
    connect(m_suffixEdit, SIGNAL(textChanged(QString)), this, SLOT(onSuffixTextChanged(QString)));
    connect(m_addButton, SIGNAL(clicked()), this, SLOT(addFileHandler()));
}

void FileHandlersDialog::setLandscapeLayout() {
    setFixedHeight(340);
    m_addButton->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(new SeparatorLabel(tr("Handlers"), this), 0, 0, 1, 2);
        m_grid->addWidget(m_handlersEdit, 1, 0, 1, 2);
        m_grid->addWidget(new SeparatorLabel(tr("Add handler"), this), 2, 0, 1, 2);
        m_grid->addWidget(new QLabel(tr("Suffix"), this), 3, 0);
        m_grid->addWidget(new QLabel(tr("Command"), this), 3, 1);
        m_grid->addWidget(m_suffixEdit, 4, 0);
        m_grid->addWidget(m_commandEdit, 4, 1);
        m_grid->addWidget(m_addButton, 4, 3);
    }
    else {
        m_grid->removeWidget(m_addButton);
        m_grid->addWidget(m_addButton, 4, 3);
    }
}

void FileHandlersDialog::setPortraitLayout() {
    setFixedHeight(600);
    m_addButton->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(new SeparatorLabel(tr("Handlers"), this), 0, 0, 1, 2);
        m_grid->addWidget(m_handlersEdit, 1, 0, 1, 2);
        m_grid->addWidget(new SeparatorLabel(tr("Add handler"), this), 2, 0, 1, 2);
        m_grid->addWidget(new QLabel(tr("Suffix"), this), 3, 0);
        m_grid->addWidget(new QLabel(tr("Command"), this), 3, 1);
        m_grid->addWidget(m_suffixEdit, 4, 0);
        m_grid->addWidget(m_commandEdit, 4, 1);
        m_grid->addWidget(m_addButton, 5, 0, 1, 2);
    }
    else {
        m_grid->removeWidget(m_addButton);
        m_grid->addWidget(m_addButton, 5, 0, 1, 2);
    }
}

void FileHandlersDialog::onFileHandlersChanged(const QVariantMap &handlers) {
    m_handlersEdit->clear();
    QStringList keys = handlers.keys();

    while (!keys.isEmpty()) {
        QString key(keys.takeFirst());
        m_handlersEdit->append(QString("%1: .%2, %3: %4").arg(tr("Suffix")).arg(key).arg(tr("Command")).arg(handlers.value(key).toString()));
    }

    if (m_handlersEdit->toPlainText().isEmpty()) {
        m_handlersEdit->setText(tr("No file handlers"));
    }
}

void FileHandlersDialog::addFileHandler() {
    QVariantMap handlers = m_session->settings()->fileHandlers();

    if (m_commandEdit->text().isEmpty()) {
        handlers.remove(m_suffixEdit->text().section('.', -1));
    }
    else {
        handlers.insert(m_suffixEdit->text().section('.', -1), m_commandEdit->text());
    }

    m_session->settings()->setFileHandlers(handlers);
    m_suffixEdit->clear();
    m_commandEdit->clear();
}

void FileHandlersDialog::onSuffixTextChanged(const QString &text) {
    m_addButton->setEnabled(!text.isEmpty());
}
