#include "settings.h"

Settings::Settings(QObject *parent) :
    QSettings(QString("Marxian"), QString("toBuntu"), parent) {
}

void Settings::restoreSettings() {
    beginGroup("Media");
    setScrobbleTracks(value("scrobbleTracks", false).toBool());
    endGroup();

    beginGroup("Transfers");
    setDownloadPath(value("downloadPath", QString("/home/user/MyDocs/toBuntu/")).toString());
    setUseDefaultDownloadPath(value("useDefaultDownloadPath", true).toBool());
    setMusicDownloadPath(QString("/home/user/MyDocs/Music/toBuntu/"));
    setDefaultTransferStatus(static_cast<TransferItem::Status>(value("defaultTransferStatus", 0).toInt()));
    endGroup();

    beginGroup("Sync");
    setSyncToUbuntuOne(value("syncToUbuntuOne", false).toBool());
    endGroup();

    beginGroup("System");
    setLanguage(value("language", QString("en")).toString());
    setScreenOrientation(static_cast<ScreenOrientation::Orientation>(value("screenOrientation", 0).toInt()));
    setFileHandlers(value("fileHandlers", QVariantMap()).toMap());
    endGroup();
}

void Settings::saveSettings() {
    beginGroup("Media");
    setValue("scrobbleTracks", scrobbleTracks());
    endGroup();

    beginGroup("Transfers");
    setValue("downloadPath", downloadPath());
    setValue("musicDownloadPath", musicDownloadPath());
    setValue("useDefaultDownloadPath", useDefaultDownloadPath());
    setValue("defaultTransferStatus", TransferItem::Status(defaultTransferStatus()));
    endGroup();

    beginGroup("Sync");
    setValue("syncToUbuntuOne", syncToUbuntuOne());
    endGroup();

    beginGroup("System");
    setValue("language", language());
    setValue("screenOrientation", ScreenOrientation::Orientation(screenOrientation()));
    setValue("fileHandlers", fileHandlers());
    endGroup();
}

void Settings::setScrobbleTracks(bool scrobble) {
    m_scrobble = scrobble;
    emit scrobbleTracksChanged(scrobble);
}

void Settings::setDownloadPath(const QString &path) {
    m_downloadPath = path;
    emit downloadPathChanged(path);
}

void Settings::setUseDefaultDownloadPath(bool useDefault) {
    m_useDefaultPath = useDefault;
    emit useDefaultDownloadPathChanged(useDefault);
}

void Settings::setMusicDownloadPath(const QString &path) {
    m_musicPath = path;
    emit musicDownloadPathChanged(path);
}

void Settings::setDefaultTransferStatus(TransferItem::Status status) {
    m_transferStatus = status;
    emit defaultTransferStatusChanged(status);
}

void Settings::setLanguage(const QString &lang) {
    m_language = lang;
    emit languageChanged(lang);
}

void Settings::setScreenOrientation(ScreenOrientation::Orientation orientation) {
    m_orientation = orientation;
    emit screenOrientationChanged(orientation);
}

void Settings::setSyncToUbuntuOne(bool sync) {
    m_sync = sync;
    emit syncToUbuntuOneChanged(sync);
}

void Settings::setFileHandlers(const QVariantMap &handlers) {
    m_fileHandlers = handlers;
    emit fileHandlersChanged(handlers);
}
