#include "folderlistdialog.h"
#include "filemodel.h"
#include "textlistdelegate.h"

FolderListDialog::FolderListDialog(Session *session, const QModelIndex &index, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_model(new SelectionModel(this)),
    m_listView(new QListView(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Choose folder"));

    m_grid->setContentsMargins(0, 0, 0 ,0);
    m_grid->addWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::AlignCenter, m_listView));

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    setCurrentIndex(index);
    onOrientationChanged();
}

void FolderListDialog::setLandscapeLayout() {
    setFixedHeight(340);
}

void FolderListDialog::setPortraitLayout() {
    setFixedHeight(600);
}

void FolderListDialog::setCurrentIndex(const QModelIndex &index) {
    if (index.isValid()) {
        m_model->addItem(index.data(FileModel::ResourcePathRole).toString(), "");

        QModelIndex parent = index.parent();

        while (parent.isValid()) {
            m_model->addItem(parent.data(FileModel::ResourcePathRole).toString(), "");
            parent = parent.parent();
        }
    }

    m_model->addItem(m_session->ubuntu()->rootNodePath(), "");
    m_listView->setCurrentIndex(m_model->index(0, 0));
}

void FolderListDialog::onItemClicked(const QModelIndex &index) {
    emit folderChosen(m_model->name(index.row()));

    accept();
}
