#include "fileitem.h"
#include "utils.h"

FileItem::FileItem(FileItem *parent) :
    QObject(parent),
    m_hasChildren(false),
    m_parent(parent)
{
}

FileItem::FileItem(const QString &fileName,
                   qint64 size,
                   bool isFolder,
                   bool hasChildren,
                   const QString &hash,
                   const QString &created,
                   const QString &modified,
                   const QString &path,
                   const QString &resourcePath,
                   const QString &contentPath,
                   const QString &volumePath,
                   const QString &parentPath,
                   const QString &key,
                   const QString &publicUrl,
                   bool isLive,
                   bool isPublic,
                   FileItem *parent) :
    QObject(parent),
    m_filename(fileName),
    m_size(size),
    m_folder(isFolder),
    m_hasChildren(hasChildren),
    m_hash(hash),
    m_created(created),
    m_modified(modified),
    m_path(path),
    m_resourcePath(resourcePath),
    m_contentPath(contentPath),
    m_volumePath(volumePath),
    m_parentPath(parentPath),
    m_key(key),
    m_url(publicUrl),
    m_live(isLive),
    m_public(isPublic),
    m_parent(parent)
{
}

FileItem::FileItem(const QVariantMap &fileMap, FileItem *parent) :
    QObject(parent),
    m_filename(fileMap.value("path").toString().section('/', -1)),
    m_size(fileMap.value("size").toLongLong()),
    m_folder(fileMap.value("kind").toString() == "directory"),
    m_hasChildren((m_folder) && (fileMap.value("has_children").toBool())),
    m_hash(fileMap.value("hash").toString()),
    m_created(Utils::localDateTimeFromString(fileMap.value("when_created").toString())),
    m_modified(Utils::localDateTimeFromString(fileMap.value("when_changed").toString())),
    m_path(fileMap.value("path").toString()),
    m_resourcePath(fileMap.value("resource_path").toString()),
    m_contentPath(fileMap.value("content_path").toString()),
    m_volumePath(fileMap.value("volume_path").toString()),
    m_parentPath(fileMap.value("parent_path").toString()),
    m_key(fileMap.value("key").toString()),
    m_url(fileMap.value("public_url").toString()),
    m_live(fileMap.value("is_live").toBool()),
    m_public(fileMap.value("is_public").toBool()),
    m_parent(parent)
{
}

FileItem::MimeType FileItem::mimeType() const {
    if (isFolder()) {
        return Folder;
    }

    QString s = suffix();

    if ((s == "doc") || (s == "xml") || (s == "txt") || (s == "html")) {
        return Document;
    }

    if (s == "pdf") {
        return PDF;
    }

    if ((s == "jpg") || (s == "jpeg") || (s == "png") || (s == "bmp") || (s == "gif")) {
        return Image;
    }

    if ((s == "mp3") || (s == "flac") || (s == "ogg") || (s == "ogg") || (s == "wav") || (s == "wma") || (s == "m4v")) {
        return Audio;
    }

    if ((s == "mp4") || (s == "flv") || (s == "avi") || (s == "mkv") || (s == "mpg") || (s == "mpeg") || (s == "divx") || (s == "xvid") || (s == "ts")) {
        return Video;
    }

    if (s == "deb") {
        return Package;
    }

    if (s == "m3u") {
        return Playlist;
    }

    if (s == "swf") {
        return Flash;
    }

    return Unknown;
}

void FileItem::appendChildFile(FileItem* file) {
    m_children.append(file);
}

void FileItem::insertChildFile(int position, FileItem *file) {
    m_children.insert(position, file);
}

void FileItem::removeChildFile(int position) {
    m_children.removeAt(position);
}

FileItem* FileItem::takeChildFile(int position) {
    return m_children.takeAt(position);
}

FileItem* FileItem::childFile(int row) const {
    if ((row >= 0) && (row < m_children.size())) {
        return m_children.at(row);
    }

    return 0;
}

int FileItem::childNumber() const {
    return !m_parent ? 0 : m_parent->childFiles().indexOf(const_cast<FileItem*>(this));
}
