/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;

public final class DEREnumerated
extends ASN1Object {
    private byte[] bytes;

    public DEREnumerated(byte[] byArray) {
        this.bytes = byArray;
    }

    public final BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(10, this.bytes);
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DEREnumerated)) {
            return false;
        }
        dERObject = (DEREnumerated)dERObject;
        return PKCS1Encoding.areEqual(this.bytes, ((DEREnumerated)dERObject).bytes);
    }

    @Override
    public final int hashCode() {
        return PKCS1Encoding.hashCode(this.bytes);
    }
}

