/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public final class JCERSAPublicKey
implements RSAPublicKey {
    private BigInteger modulus;
    private BigInteger publicExponent;

    JCERSAPublicKey(RSAKeyParameters rSAKeyParameters) {
        this.modulus = rSAKeyParameters.getModulus();
        this.publicExponent = rSAKeyParameters.getExponent();
    }

    JCERSAPublicKey(SubjectPublicKeyInfo aSN1Encodable) {
        try {
            aSN1Encodable = new RSAPublicKeyStructure((ASN1Sequence)((SubjectPublicKeyInfo)aSN1Encodable).getPublicKey());
            this.modulus = ((RSAPublicKeyStructure)aSN1Encodable).getModulus();
            this.publicExponent = ((RSAPublicKeyStructure)aSN1Encodable).getPublicExponent();
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in RSA public key");
        }
    }

    @Override
    public final BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public final BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public final String getAlgorithm() {
        return "RSA";
    }

    @Override
    public final String getFormat() {
        return "X.509";
    }

    @Override
    public final byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPublicKeyStructure(this.getModulus(), this.getPublicExponent()).getDERObject());
        return subjectPublicKeyInfo.getDEREncoded();
    }

    public final int hashCode() {
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        object = (RSAPublicKey)object;
        return this.getModulus().equals(object.getModulus()) && this.getPublicExponent().equals(object.getPublicExponent());
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("RSA Public Key").append(string);
        stringBuffer.append("            modulus: ").append(this.getModulus().toString(16)).append(string);
        stringBuffer.append("    public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        return stringBuffer.toString();
    }
}

