/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public final class JDKDSAPublicKey
implements DSAPublicKey {
    private BigInteger y;
    private DSAParams dsaSpec;

    JDKDSAPublicKey(SubjectPublicKeyInfo aSN1Encodable) {
        DEREncodable dEREncodable;
        try {
            dEREncodable = (DERInteger)((SubjectPublicKeyInfo)aSN1Encodable).getPublicKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
        this.y = dEREncodable.getValue();
        dEREncodable = ((SubjectPublicKeyInfo)aSN1Encodable).getAlgorithmId().getParameters();
        if (dEREncodable != null && !DERNull.INSTANCE.equals(dEREncodable)) {
            aSN1Encodable = new DSAParameter((ASN1Sequence)((SubjectPublicKeyInfo)aSN1Encodable).getAlgorithmId().getParameters());
            this.dsaSpec = new DSAParameterSpec(((DSAParameter)aSN1Encodable).getP(), ((DSAParameter)aSN1Encodable).getQ(), ((DSAParameter)aSN1Encodable).getG());
        }
    }

    @Override
    public final String getAlgorithm() {
        return "DSA";
    }

    @Override
    public final String getFormat() {
        return "X.509";
    }

    @Override
    public final byte[] getEncoded() {
        if (this.dsaSpec == null) {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new DERInteger(this.y)).getDEREncoded();
        }
        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(this.dsaSpec.getP(), this.dsaSpec.getQ(), this.dsaSpec.getG()).getDERObject()), new DERInteger(this.y)).getDEREncoded();
    }

    @Override
    public final DSAParams getParams() {
        return this.dsaSpec;
    }

    @Override
    public final BigInteger getY() {
        return this.y;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("DSA Public Key").append(string);
        stringBuffer.append("            y: ").append(this.getY().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public final int hashCode() {
        return this.getY().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        object = (DSAPublicKey)object;
        return this.getY().equals(object.getY()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getQ().equals(object.getParams().getQ());
    }
}

