/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public final class DSAParameter
extends ASN1Encodable {
    private DERInteger p;
    private DERInteger q;
    private DERInteger g;

    public DSAParameter(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new DERInteger(bigInteger);
        this.q = new DERInteger(bigInteger2);
        this.g = new DERInteger(bigInteger3);
    }

    public DSAParameter(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + ((ASN1Sequence)object).size());
        }
        object = ((ASN1Sequence)object).getObjects();
        this.p = DERInteger.getInstance(object.nextElement());
        this.q = DERInteger.getInstance(object.nextElement());
        this.g = DERInteger.getInstance(object.nextElement());
    }

    public final BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public final BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public final BigInteger getG() {
        return this.g.getPositiveValue();
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.q);
        aSN1EncodableVector.add(this.g);
        return new DERSequence(aSN1EncodableVector);
    }
}

