/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERIA5String
extends ASN1Object
implements DERString {
    private String string;

    public DERIA5String(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    private DERIA5String(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("string cannot be null");
        }
        this.string = string;
    }

    @Override
    public final String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    @Override
    final void encode(DEROutputStream object) throws IOException {
        DEROutputStream dEROutputStream = object;
        object = this;
        char[] cArray = ((DERIA5String)object).string.toCharArray();
        object = cArray;
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != ((Object)object).length; ++i) {
            byArray[i] = (byte)object[i];
        }
        dEROutputStream.writeEncoded(22, byArray);
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERIA5String)) {
            return false;
        }
        dERObject = (DERIA5String)dERObject;
        return this.getString().equals(((DERIA5String)dERObject).getString());
    }
}

