/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;

final class IntArray {
    private int[] m_ints;

    public IntArray(int n) {
        this.m_ints = new int[n];
    }

    private IntArray(int[] nArray) {
        this.m_ints = nArray;
    }

    public IntArray(BigInteger object, int n) {
        int n2;
        int n3;
        if (((BigInteger)object).signum() == -1) {
            throw new IllegalArgumentException("Only positive Integers allowed");
        }
        if (((BigInteger)object).equals(ECConstants.ZERO)) {
            this.m_ints = new int[]{0};
            return;
        }
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        Object object2 = byArray.length;
        Object object3 = 0;
        if (object[0] == false) {
            --object2;
            object3 = 1;
        }
        this.m_ints = (n3 = (object2 + 3) / 4) < n ? new int[n] : new int[n3];
        n = n3 - 1;
        object2 = object2 % 4 + object3;
        n3 = 0;
        if (object3 < object2) {
            for (n2 = object3; n2 < object2; ++n2) {
                n3 <<= 8;
                Object object4 = object[n2];
                object3 = object4;
                if (object4 < 0) {
                    object3 += 256;
                }
                n3 |= object3;
            }
            this.m_ints[n--] = n3;
        }
        while (n >= 0) {
            n3 = 0;
            for (object3 = 0; object3 < 4; ++object3) {
                n3 <<= 8;
                Object object5 = object[n2++];
                object2 = object5;
                if (object5 < 0) {
                    object2 += 256;
                }
                n3 |= object2;
            }
            this.m_ints[n] = n3;
            --n;
        }
    }

    public final boolean isZero() {
        return this.m_ints.length == 0 || this.m_ints[0] == 0 && this.getUsedLength() == 0;
    }

    private int getUsedLength() {
        int n = this.m_ints.length;
        if (n <= 0) {
            return 0;
        }
        if (this.m_ints[0] != 0) {
            while (this.m_ints[--n] == 0) {
            }
            return n + 1;
        }
        do {
            if (this.m_ints[--n] == 0) continue;
            return n + 1;
        } while (n > 0);
        return 0;
    }

    public final int bitLength() {
        int n = this.getUsedLength();
        if (n == 0) {
            return 0;
        }
        int n2 = this.m_ints[--n];
        n = (n << 5) + 1;
        if ((n2 & 0xFFFF0000) != 0) {
            if ((n2 & 0xFF000000) != 0) {
                n += 24;
                n2 >>>= 24;
            } else {
                n += 16;
                n2 >>>= 16;
            }
        } else if (n2 > 255) {
            n += 8;
            n2 >>>= 8;
        }
        while (n2 != 1) {
            ++n;
            n2 >>>= 1;
        }
        return n;
    }

    private int[] resizedInts(int n) {
        int[] nArray = new int[n];
        int n2 = this.m_ints.length;
        n = n2 < n ? n2 : n;
        System.arraycopy(this.m_ints, 0, nArray, 0, n);
        return nArray;
    }

    public final BigInteger toBigInteger() {
        int n;
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return ECConstants.ZERO;
        }
        int n3 = this.m_ints[n2 - 1];
        byte[] byArray = new byte[4];
        int n4 = 0;
        boolean bl = false;
        for (n = 3; n >= 0; --n) {
            byte by = (byte)(n3 >>> n * 8);
            if (!bl && by == 0) continue;
            bl = true;
            byArray[n4++] = by;
        }
        n = 4 * (n2 - 1) + n4;
        byte[] byArray2 = new byte[n];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray2[n3] = byArray[n3];
        }
        for (n3 = n2 - 2; n3 >= 0; --n3) {
            for (n2 = 3; n2 >= 0; --n2) {
                byArray2[n4++] = (byte)(this.m_ints[n3] >>> n2 * 8);
            }
        }
        return new BigInteger(1, byArray2);
    }

    public final IntArray shiftLeft(int n) {
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return this;
        }
        if (n == 0) {
            return this;
        }
        if (n > 31) {
            throw new IllegalArgumentException("shiftLeft() for max 31 bits , " + n + "bit shift is not possible");
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 32 - n;
        nArray[0] = this.m_ints[0] << n;
        for (int i = 1; i < n2; ++i) {
            nArray[i] = this.m_ints[i] << n | this.m_ints[i - 1] >>> n3;
        }
        nArray[n2] = this.m_ints[n2 - 1] >>> n3;
        return new IntArray(nArray);
    }

    public final void addShifted(IntArray intArray, int n) {
        int n2 = intArray.getUsedLength();
        int n3 = n2 + n;
        if (n3 > this.m_ints.length) {
            this.m_ints = this.resizedInts(n3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = n3 + n;
            this.m_ints[n4] = this.m_ints[n4] ^ intArray.m_ints[n3];
        }
    }

    private void flipBit(int n) {
        int n2 = n >> 5;
        n &= 0x1F;
        n = 1 << n;
        int n3 = n2;
        this.m_ints[n3] = this.m_ints[n3] ^ n;
    }

    public final void setBit(int n) {
        int n2 = n >> 5;
        n &= 0x1F;
        n = 1 << n;
        int n3 = n2;
        this.m_ints[n3] = this.m_ints[n3] | n;
    }

    public final IntArray multiply(IntArray intArray, int n) {
        int n2 = n + 31 >> 5;
        if (this.m_ints.length < n2) {
            this.m_ints = this.resizedInts(n2);
        }
        IntArray intArray2 = intArray;
        intArray = new IntArray(intArray.resizedInts(intArray2.m_ints.length + 1));
        IntArray intArray3 = new IntArray(n + n + 31 >> 5);
        int n3 = 1;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < n2; ++j) {
                if ((this.m_ints[j] & n3) == 0) continue;
                intArray3.addShifted(intArray, j);
            }
            n3 <<= 1;
            intArray2 = intArray;
            int n4 = intArray2.getUsedLength();
            if (n4 == 0) continue;
            if (intArray2.m_ints[n4 - 1] < 0 && ++n4 > intArray2.m_ints.length) {
                intArray2.m_ints = intArray2.resizedInts(intArray2.m_ints.length + 1);
            }
            boolean bl = false;
            for (int j = 0; j < n4; ++j) {
                boolean bl2 = intArray2.m_ints[j] < 0;
                int n5 = j;
                intArray2.m_ints[n5] = intArray2.m_ints[n5] << 1;
                if (bl) {
                    int n6 = j;
                    intArray2.m_ints[n6] = intArray2.m_ints[n6] | 1;
                }
                bl = bl2;
            }
        }
        return intArray3;
    }

    public final void reduce(int n, int[] nArray) {
        for (int i = n + n - 2; i >= n; --i) {
            int n2 = i;
            IntArray intArray = this;
            int n3 = n2 >> 5;
            n2 &= 0x1F;
            if (!((intArray.m_ints[n3] & (n2 = 1 << n2)) != 0)) continue;
            int n4 = i - n;
            this.flipBit(n4);
            this.flipBit(i);
            n2 = nArray.length;
            while (--n2 >= 0) {
                this.flipBit(nArray[n2] + n4);
            }
        }
        this.m_ints = this.resizedInts(n + 31 >> 5);
    }

    public final IntArray square(int n) {
        int[] nArray = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85};
        if (this.m_ints.length < (n = n + 31 >> 5)) {
            this.m_ints = this.resizedInts(n);
        }
        IntArray intArray = new IntArray(n + n);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                n5 >>>= 8;
                n3 = this.m_ints[i] >>> (n4 << 2) & 0xF;
                n2 = nArray[n3] << 24;
                n5 |= n2;
            }
            intArray.m_ints[i + i] = n5;
            n5 = 0;
            n4 = this.m_ints[i] >>> 16;
            for (n3 = 0; n3 < 4; ++n3) {
                n5 >>>= 8;
                n2 = n4 >>> (n3 << 2) & 0xF;
                n2 = nArray[n2] << 24;
                n5 |= n2;
            }
            intArray.m_ints[i + i + 1] = n5;
        }
        return intArray;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof IntArray)) {
            return false;
        }
        object = (IntArray)object;
        int n = this.getUsedLength();
        if (super.getUsedLength() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_ints[i] == ((IntArray)object).m_ints[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n = this.getUsedLength();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + this.m_ints[i];
        }
        return n2;
    }

    public final Object clone() {
        int[] nArray;
        int[] nArray2 = this.m_ints;
        if (this.m_ints == null) {
            nArray = null;
        } else {
            int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArray = nArray3;
        }
        return new IntArray(nArray);
    }

    public final String toString() {
        int n = this.getUsedLength();
        if (n == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.m_ints[n - 1]));
        n -= 2;
        while (n >= 0) {
            String string = Integer.toBinaryString(this.m_ints[n]);
            for (int i = string.length(); i < 8; ++i) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            --n;
        }
        return stringBuffer.toString();
    }
}

