/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

public abstract class ASN1TaggedObject
extends ASN1Object
implements DEREncodable {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    DEREncodable obj = null;

    public ASN1TaggedObject(int n, DEREncodable dEREncodable) {
        this.explicit = true;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    public ASN1TaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        this.explicit = dEREncodable instanceof ASN1Choice ? true : bl;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1TaggedObject)) {
            return false;
        }
        dERObject = (ASN1TaggedObject)dERObject;
        if (this.tagNo != ((ASN1TaggedObject)dERObject).tagNo || this.explicit != ((ASN1TaggedObject)dERObject).explicit) {
            return false;
        }
        return !(this.obj == null ? ((ASN1TaggedObject)dERObject).obj != null : !this.obj.getDERObject().equals(((ASN1TaggedObject)dERObject).obj.getDERObject()));
    }

    @Override
    public int hashCode() {
        int n = this.tagNo;
        if (this.obj != null) {
            n ^= this.obj.hashCode();
        }
        return n;
    }

    public final int getTagNo() {
        return this.tagNo;
    }

    public final boolean isExplicit() {
        return this.explicit;
    }

    public final DERObject getObject() {
        if (this.obj != null) {
            return this.obj.getDERObject();
        }
        return null;
    }

    public String toString() {
        return "[" + this.tagNo + "]" + this.obj;
    }
}

