/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSetParser;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, inputStream instanceof DefiniteLengthInputStream ? ((DefiniteLengthInputStream)inputStream).getRemaining() : Integer.MAX_VALUE);
    }

    public ASN1StreamParser(InputStream inputStream, int n) {
        this._in = inputStream;
        this._limit = n;
    }

    public final DEREncodable readObject() throws IOException {
        int n = this._in.read();
        if (n == -1) {
            return null;
        }
        boolean bl = false;
        ASN1StreamParser aSN1StreamParser = this;
        if (aSN1StreamParser._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)aSN1StreamParser._in).setEofOn00(false);
        }
        int n2 = ASN1InputStream.readTagNumber(this._in, n);
        boolean bl2 = (n & 0x20) != 0;
        int n3 = ASN1InputStream.readLength(this._in, this._limit);
        if (n3 < 0) {
            if (!bl2) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            if ((n & 0x40) != 0) {
                ASN1StreamParser aSN1StreamParser2 = new ASN1StreamParser(indefiniteLengthInputStream, this._limit);
                return new BERApplicationSpecificParser(n2, aSN1StreamParser2);
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(n, n2, indefiniteLengthInputStream);
            }
            ASN1StreamParser aSN1StreamParser3 = new ASN1StreamParser(indefiniteLengthInputStream, this._limit);
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser3);
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser3);
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser3);
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser3);
                }
            }
            throw new IOException("unknown BER object encountered: 0x" + Integer.toHexString(n2));
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n3);
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(bl2, n2, definiteLengthInputStream.toByteArray());
        }
        if ((n & 0x80) != 0) {
            return new BERTaggedObjectParser(n, n2, definiteLengthInputStream);
        }
        if (bl2) {
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(definiteLengthInputStream));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(definiteLengthInputStream));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(definiteLengthInputStream));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(definiteLengthInputStream));
                }
            }
            return new DERUnknownTag(true, n2, definiteLengthInputStream.toByteArray());
        }
        switch (n2) {
            case 4: {
                return new DEROctetStringParser(definiteLengthInputStream);
            }
        }
        return ASN1InputStream.createPrimitiveDERObject(n2, definiteLengthInputStream.toByteArray());
    }

    final ASN1EncodableVector readVector() throws IOException {
        DEREncodable dEREncodable;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dEREncodable = this.readObject()) != null) {
            aSN1EncodableVector.add(dEREncodable.getDERObject());
        }
        return aSN1EncodableVector;
    }

    public ASN1StreamParser() {
    }

    public static void writeInputStreamToFile(InputStream inputStream, String object) throws IOException {
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        if (n >= 0) {
            Object object2;
            if (!((File)(object = new File((String)object))).exists()) {
                object2 = ((File)object).getParentFile();
                if (object2 != null && !((File)object2).exists()) {
                    ((File)object2).mkdirs();
                }
                ((File)object).createNewFile();
            }
            object2 = new FileOutputStream((File)object);
            while (n >= 0) {
                ((OutputStream)object2).write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            ((OutputStream)object2).flush();
            ((OutputStream)object2).close();
        }
    }
}

