/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.springframework;

import ch.elca.el4j.services.xmlmerge.AbstractXmlMergeException;
import ch.elca.el4j.services.xmlmerge.ConfigurationException;
import ch.elca.el4j.services.xmlmerge.XmlMerge;
import ch.elca.el4j.services.xmlmerge.config.ConfigurableXmlMerge;
import ch.elca.el4j.services.xmlmerge.config.PropertyXPathConfigurer;
import ch.elca.el4j.services.xmlmerge.merge.DefaultXmlMerge;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class XmlMergeResource
extends AbstractResource {
    InputStream m_result;
    List m_resources;
    XmlMerge m_xmlMerge;
    Map m_properties;

    public String getDescription() {
        return "Resource merging other XML resources using XmlMerge";
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_properties == null) {
            this.m_xmlMerge = new DefaultXmlMerge();
        } else {
            try {
                this.m_xmlMerge = new ConfigurableXmlMerge(new PropertyXPathConfigurer(this.m_properties));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.m_resources == null) {
            throw new RuntimeException("Resources not set");
        }
        InputStream[] sources = new InputStream[this.m_resources.size()];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = ((Resource)this.m_resources.get(i)).getInputStream();
        }
        try {
            return this.m_xmlMerge.merge(sources);
        }
        catch (AbstractXmlMergeException e) {
            throw new RuntimeException(e);
        }
    }

    public void setResources(List resources) {
        this.m_resources = resources;
    }

    public void setProperties(Map map) {
        this.m_properties = map;
    }
}

