//*****************************************************************************
//*
//*
//*     SystemWin.cpp
//*
//*
//*****************************************************************************
//
//  This file is an implementation of system functions for WINDOWS
//
//  Warnig in this file are not all part implemented an tested
//
#include    <windows.h>
#include    <stdio.h>
#include    <time.h>
#include    "System.h"

#define SYS_API         /*extern "C"*/
#define SYS_ERROR()     GetSystemError(GetLastError())

#ifdef  WIN32

    #define     SYS_NEW_HANDLE(h,n,e) ((SysFile)h)
    #define     SYS_GET_HANDLE(h)     ((HANDLE)h)
    #define     SYS_DEL_HANDLE(h)

#else

    #error  Not Supported

#endif


typedef struct
	{
    ULONG			uStatus;
    ULONG			uInformation;
	}IO_STATUS_BLOCK_;

typedef struct _FILE_NAME_INFORMATION
	{
    ULONG			uFileNameLength;
    WCHAR			aFileName[256];
	}FILE_NAME_INFORMATION_;

typedef struct
    {
    void (_cdecl   *pProc)(void*);
    void           *pParam;
    const char     *pName;
    int             iPrior;
    }ThreadData;

typedef LONG  (__stdcall *NtQueryInformationFileType)(HANDLE hFileHandle,IO_STATUS_BLOCK_ *pIoStatusBlock,PVOID pFileInformation,ULONG uLength,UINT uInfoMode);


static NtQueryInformationFileType	pNtQueryInformationFile=0;
static HMODULE						hNtDll=0;
static int          iTimeInit   = 0;
static const int    aTpPDays [] = {  0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366, 366, 366,   0};
static const int    aTpDays  [] = {  0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365, 365, 365,   0};
static int          aPrio    [] = { THREAD_PRIORITY_TIME_CRITICAL,
                                    THREAD_PRIORITY_HIGHEST,
                                    THREAD_PRIORITY_ABOVE_NORMAL,
                                    THREAD_PRIORITY_NORMAL,
                                    THREAD_PRIORITY_BELOW_NORMAL,
                                    THREAD_PRIORITY_LOWEST,
                                    THREAD_PRIORITY_IDLE
                                  };



//*****************************************************************************
//*
//*     GetSystemError
//*
//*****************************************************************************
//  Eine Windows Fehlermeldung in eine Systemfehlermeldung umwandeln
static int GetSystemError(int iError)
{

    if(!iError)return SYS_ERR_NONE;

    switch(iError)
        {
    case ERROR_INVALID_HANDLE:
    case ERROR_BAD_COMMAND:
                                    return SYS_ERR_PARAM;

    case ERROR_INVALID_DRIVE:
                                    return SYS_ERR_INVALID_FILENAME;

    case ERROR_FILE_NOT_FOUND:
                                    return SYS_ERR_FILE_NOT_FOUND;

    case ERROR_NETWORK_ACCESS_DENIED:
    case ERROR_ACCESS_DENIED:
    case ERROR_WRITE_PROTECT:
                                    return SYS_ERR_ACCESS_DENIED;

    case ERROR_TOO_MANY_OPEN_FILES:
                                    return SYS_ERR_NO_HANDLES;

    case ERROR_PATH_NOT_FOUND:
    case ERROR_BAD_NETPATH:
    case ERROR_DEV_NOT_EXIST:
                                    return SYS_ERR_PATH_NOTFOUND;
    case ERROR_HANDLE_DISK_FULL:
    case ERROR_DISK_FULL:
                                    return SYS_ERR_DISKFULL;
        }



return SYS_ERR_UNKNOWN;
}

//*****************************************************************************
//*
//*     SysClearFindStruct
//*
//*****************************************************************************
//  Lscht eine Find-Struktur
//  pFind   : Zeiger auf die Find-Struktur
inline void SysClearFindStruct(SysFindStruct *pFind)
{

    pFind->dwSize=0;
    pFind->cName[0]=0;
    #if SYS_HAS_SHORT_NAME
    pFind->cShortName[0]=0;
    #endif
}

//*****************************************************************************
//*
//*     SysCopyShortName
//*
//*****************************************************************************
#if SYS_HAS_SHORT_NAME
inline void SysCopyShortName(char *pName,WIN32_FIND_DATA *pEntry)
{
const char  *pPtr;
char         c;
int          i;



    pPtr=pEntry->cAlternateFileName;

    for(i=0;i<14;i++)
        {
        c=pPtr[i];
        if(c==' ' || c==0)break;
        pName[i]=c;
        }

    pName[i]=0;

}
#endif

//*****************************************************************************
//*
//*     SysTimeConvert     DOSTIME --> SysTime
//*
//*****************************************************************************
//  Konvertiert eine DOS Zeit in die Systemzeit
//  uDosTime    : Ist die DOS Zeit
//  pSysTime    : Zeiger auf Puffer fr die Systemzeit
//  Ergibt 1 wenn erfolgreich ansonsten 0
SYS_API int SysTimeConvertDS(SysDW uDosTime ,SysTime *pSysTime)
{
unsigned int    uVal,uYear,uDays;
unsigned short  wTime,wDate;



    wTime=(unsigned short) uDosTime;
    wDate=(unsigned short)(uDosTime>>16);

       uYear = (wDate>>9)+80;
    if(uYear>2038)
        {
        *pSysTime=0;
        return FALSE;
        }

    if(uYear&3)uDays  = aTpDays  [((wDate>>5)-1)&15];
    else       uDays  = aTpPDays [((wDate>>5)-1)&15];
               uDays += ((wDate)&0x1F)-1;
               uDays += (uYear-70  )*365;
               uDays += (uYear-70+1)>>2;

               uVal   = uDays*24;
               uVal  += (wTime>>11);
               uVal  *= 60;
               uVal  += (wTime>> 5)&0x3F;
               uVal  *= 60;
               uVal  += (wTime<< 1)&0x3F;
    *pSysTime =uVal;


return 1;
}

//*****************************************************************************
//*
//*     SysTimeConvert     SysTime --> DOSTIME
//*
//*****************************************************************************
//  Konvertiert eine eine Systemzeit in eine DOS-Zeit
//  uSysTime    : Ist die Systemzeit
//  pDosTime    : Zeiger auf Puffer fr die DOS Zeit
//  Ergibt 1 wenn erfolgreich ansonsten 0
SYS_API int SysTimeConvertSD(SysTime uSysTime,SysDW *pDosTime)
{
struct tm      *pGlobal;
unsigned short  wTime,wDate;


       pGlobal=gmtime((const time_t*)&uSysTime );
    if(pGlobal==NULL || pGlobal->tm_year<80 || pGlobal->tm_year>143)
        {
        *pDosTime = 1<<5;
        return FALSE;
        }

    wDate = (pGlobal->tm_mday  ) | ((pGlobal->tm_mon+1)<<5) | ((pGlobal->tm_year-80)<< 9);
    wTime = (pGlobal->tm_sec>>1) | ( pGlobal->tm_min   <<5) | ( pGlobal->tm_hour    <<11);

    *pDosTime = wTime|(wDate<<16);


return 1;
}

//*****************************************************************************
//*
//*     SysTimeConvertSF        SysTime --> LONGTIME
//*
//*****************************************************************************
//  Konvertiert eine SystemZeit in eine Windows Filetime (100ns)
//  uSysTime    : Ist die SystemZeit
//  pWftTime    : Zeiger auf Puffer fr die Windows Filetime
//  Ergibt 1 wenn erfolgreich ansonsten 0
SYS_API int SysTimeConvertSF(SysTime uSysTime,void  *pWftTime)
{
union   {
        __int64     i64;
        DWORD       dw[2];
        }uVal;


    if(uSysTime==0xFFFFFFFF || uSysTime==0)
        {
        ((SysDW*)pWftTime)[1] = 0xFFFFFFFF;
        ((SysDW*)pWftTime)[0] = 0xFFFFFFFF;
        return 0;
        }


    uVal.i64  = uSysTime;
    uVal.i64 *= 10000000;                       // Sekunden zu 100ns umwandeln
    uVal.i64 += (__int64)0x019db1ded53e8000L;

    ((SysDW*)pWftTime)[1] = uVal.dw[1];         // Zeit speichern
    ((SysDW*)pWftTime)[0] = uVal.dw[0];


return 1;
}

//*****************************************************************************
//*
//*     SysTimeConvertFS        LONGTIME --> SysTime
//*
//*****************************************************************************
//  Konvertiert eine Windows Filetime in eine Systemzeit
//  uDosTime    : Ist der Zeiger auf die Windows Filetime
//  pSysTime    : Zeiger auf Puffer fr die Systemzeit
//  Ergibt 1 wenn erfolgreich ansonsten 0
SYS_API int SysTimeConvertFS(const void *pWftTime,SysDW *pSysTime)
{
union   {
        __int64     i64;
        DWORD       dw[2];
        }uVal;


    uVal.i64  = *(__int64*)pWftTime;
    uVal.i64 -= 0x019db1ded53e8000;

    if(uVal.dw[1]&0x80000000)                   // Zeit vor Mi 1.Jan.1970
        {
        *pSysTime=0;
        return 0;
        }

    uVal.i64 /= 10000000;                       // 100ns zu Sekunden umwandeln

    if(uVal.dw[1]&0x80000000)                   // ber Jahr 2106
        {
        *pSysTime=0xFFFFFFFF;
        return FALSE;
        }

    *pSysTime = uVal.dw[0];                     // Systemzeit speichern


return 1;
}

//******************************************************************************
//*
//*     SysTimeConvertSU        SysTime --> time_t
//*
//******************************************************************************
//  Konvertiert eine Systemzeit in eine UTC Zeit(time_t)
//  uSysTime    : Ist der Zeiger auf die Windows Filetime
//  pUtcTime    : Zeiger auf Puffer fr die UTC-Zeit
//  Ergibt 1 wenn erfolgreich ansonsten 0
SYS_API int SysTimeConvertSU(SysTime uSysTime,void *pUtcTime)
{

    *(time_t*)pUtcTime = uSysTime;

return (uSysTime==0xFFFFFFFF)? 0:1;
}

//******************************************************************************
//*
//*     SysTimeConvertUS    time_t --> SysTime
//*
//******************************************************************************
//  Konvertiert eine UTC Zeit(time_t) in eine Systemzeit
//  pUtcTime    : Ist der Zeiger auf die UTZ-Zeit
//  pSysTime    : Zeiger auf Puffer fr die Systemzeit
//  Ergibt 1 wenn erfolgreich ansonsten 0
SYS_API int SysTimeConvertUS(const void *pUtcTime,SysTime *pSysTime)
{

    *(SysTime*)pSysTime = *(SysTime*)pUtcTime;


return (*pSysTime==0xFFFFFFFF || *pSysTime==0)? 0:1;
}


//******************************************************************************
//*
//*     SysTimeGet
//*
//******************************************************************************
//  Returns the current system time
SYS_API SysTime SysTimeGet()
{
return time(0);
}

//*****************************************************************************
//*
//*     SysTimeToStruct
//*
//*****************************************************************************
//  Converts a SysTime value in a time structure
//  uTime   : global time in seconds from 1.Jan.2000
//  pData   : pointer to the time structure for the global time
//  uTime   : global time value that will converted
//  uMode   : is the conversion mode
//              0 = global time
//              1 = local time
//              2 = local time wihout daylight saving
SYS_API void SysTimeToStruct(SysTimeStruct *pData,SysTime uTime,unsigned uMode)
{
time_t      iUtc;
struct tm  *pTimeTm;


    if(!iTimeInit)
        {
        iTimeInit=1;
        time(0);
        }

    iUtc = uTime;

    switch(uMode)
        {
    case 2:     iUtc    -= _timezone;
    case 0:     pTimeTm  =  gmtime   (&iUtc);   break;
    case 1:     pTimeTm  =  localtime(&iUtc);   break;
    default:    memset(pData,0,sizeof(SysTimeStruct));
                return;
        }

    if(pTimeTm)
        {
        pData->usYear   = (unsigned short) (pTimeTm->tm_year+1900);
        pData->ucMonth  = (unsigned char ) (pTimeTm->tm_mon+1);
        pData->ucDay    = (unsigned char )  pTimeTm->tm_mday;
        pData->ucHour   = (unsigned char )  pTimeTm->tm_hour;
        pData->ucMinute = (unsigned char )  pTimeTm->tm_min;
        pData->ucSecond = (unsigned char )  pTimeTm->tm_sec;
        pData->ucIsDst  = (unsigned char )((pTimeTm->tm_isdst)? 1:0);
        }
    else{
        pData->usYear   = 0;
        pData->ucMonth  = 0;
        pData->ucDay    = 0;
        pData->ucHour   = 0;
        pData->ucMinute = 0;
        pData->ucSecond = 0;
        pData->ucIsDst  = 0;
        }

}

//*****************************************************************************
//*
//*     SysTimeFromData
//*
//*****************************************************************************
//  Converts the local time from a time structure in a SysTime value
//  pData   : pointer to the time structure
//  uMode   : is the conversion mode
//              0 = pData is a global time
//              1 = pData is a local time ucIsDst is valid
//              2 = pData is a local time ucIsDst is in valid
//  Returns the converted time or 0xFFFFFFFF at an error
SYS_API SysTime SysTimeFromStruct(const SysTimeStruct *pData,unsigned uMode)
{
time_t          iUtc;
struct tm       sTimeTm;


    if(!iTimeInit)
        {
        iTimeInit=1;
        time(0);
        }


    sTimeTm.tm_wday  =  0;
    sTimeTm.tm_yday  =  0;
    sTimeTm.tm_year  =  pData->usYear-1900;
    sTimeTm.tm_mon   =  pData->ucMonth-1;
    sTimeTm.tm_mday  =  pData->ucDay;
    sTimeTm.tm_hour  =  pData->ucHour;
    sTimeTm.tm_min   =  pData->ucMinute;
    sTimeTm.tm_sec   =  pData->ucSecond;

    switch(uMode)
        {
    case 0:     sTimeTm.tm_isdst =  0;
                iUtc  = mktime(&sTimeTm);
                if(iUtc<=0)return 0xFFFFFFFF;
                iUtc += _timezone;
                break;

    case 1:     sTimeTm.tm_isdst =  (pData->ucIsDst)? 1:0;
                iUtc = mktime(&sTimeTm);
                break;

    case 2:     sTimeTm.tm_isdst = -1;
                iUtc = mktime(&sTimeTm);
                break;

    default:    return 0xFFFFFFFF;
        }


    if(iUtc<=0)return 0xFFFFFFFF;


return iUtc;
}

//*****************************************************************************
//*
//*     SysTimeToWeekday
//*
//*****************************************************************************
//  Converts a systime to the weekday
//  uSysTime    : is the systime value
//  Returns the weekday of the systemtime (0..6, sunday=0)
SYS_API SysDW SysTimeToWeekday(SysTime uSysTime)
{
unsigned    uTime;



    if(!iTimeInit)
        {
        iTimeInit=1;
        time(0);
        }


    uTime = uSysTime-_timezone;


return ((uTime/(3600*24)+4))%7;
}

//*****************************************************************************
//*
//*     SysOpenEx
//*
//*****************************************************************************/
//  Opens a file
//  pFilename   : name of the file
//  uFlags      : acces flags
//                  SYS_READ
//                  SYS_WRITE
//                  SYS_CREATE
//                  SYS_TRUNC
//  pError      : here the error code (below zero or 0 if ok) will be stored.
//                if this pontier is zero no error code will be stored.
//  Return the file handle or 0 if an error occurs
SYS_API SysFile SysOpenEx(const char *pFilename,unsigned uFlags,int *pError)
{
DWORD   dwAttribut=FILE_ATTRIBUTE_NORMAL;
DWORD   dwCreation=OPEN_EXISTING;
DWORD   dwAccess=0;
DWORD   dwShare=0;
HANDLE  hFile;


    if(uFlags&SYS_READ    )dwAccess  |=GENERIC_READ;
    if(uFlags&SYS_WRITE   )dwAccess  |=GENERIC_WRITE;
    if(uFlags&SYS_SYSTEM  )dwAttribut|=FILE_ATTRIBUTE_SYSTEM;
    if(uFlags&SYS_HIDDEN  )dwAttribut|=FILE_ATTRIBUTE_HIDDEN;
    if(uFlags&SYS_ARCHIVE )dwAttribut|=FILE_ATTRIBUTE_ARCHIVE;
    if(uFlags&SYS_SHARE_RD)dwShare   |=FILE_SHARE_READ;
    if(uFlags&SYS_SHARE_WR)dwShare   |=FILE_SHARE_WRITE;
    if(uFlags&SYS_TRUNC   )
        {
        dwCreation = (uFlags&SYS_CREATE)? CREATE_NEW:TRUNCATE_EXISTING;
        }
    else{
        if(uFlags&SYS_CREATE)dwCreation=OPEN_ALWAYS;
        }


    hFile = CreateFile(pFilename,dwAccess,dwShare,0,dwCreation,dwAttribut,0);

    if(hFile==INVALID_HANDLE_VALUE)
        {
        if(pError)*pError=SYS_ERROR();
        return 0;
        }


    if(pError)*pError=SYS_ERR_NONE;



return SYS_NEW_HANDLE(hFile,pFilename,pError);
}


//*****************************************************************************
//*
//*     SysGetFullPath
//*
//*****************************************************************************
//  converts a relative path to a full path
//  pFilename   : is the relative path
//  pBuffer     : is the buffer for the full path
//  iMax        : is the size of the buffer
//  returns the lenght in bytes of the full path name.
int SysGetFullPath(const char *pFilename,char *pBuffer,int iMax)
{

    if(iMax<=0)return 0;

return GetFullPathName(pFilename,iMax,pBuffer,NULL);
}


//*****************************************************************************
//*
//*     SysClose
//*
//*****************************************************************************/
//  close a file
//  return 0 if all is ok, or an error code below zero
SYS_API int SysClose(SysFile hHandle)
{
HANDLE  hFile;


    hFile = SYS_GET_HANDLE(hHandle);
            SYS_DEL_HANDLE(hHandle);

    if(CloseHandle(hFile))return 0;


return SYS_ERROR();
}

//*****************************************************************************
//*
//*     SysFlush
//*
//*****************************************************************************/
//  flush the file buffers
//  return 0 if all is ok, or error code below zero
SYS_API int SysFlush(SysFile hHandle)
{
HANDLE  hFile;


    hFile = SYS_GET_HANDLE(hHandle);

    if(FlushFileBuffers(hFile))return 0;



return SYS_ERROR();
}

//*****************************************************************************
//*
//*     SysSeek
//*
//*****************************************************************************/
//  seeks the file pointer
//  return the new file position or an error code below zero
SYS_API int SysSeek(SysFile hHandle,SysDW dwOffset,int iType)
{
static const int    aTypes[4]={FILE_BEGIN,FILE_CURRENT,FILE_END,FILE_BEGIN};
DWORD               dwPos;
HANDLE              hFile;



    hFile = SYS_GET_HANDLE(hHandle);
    dwPos = SetFilePointer(hFile,dwOffset,0,aTypes[iType&3]);


return (dwPos==0xFFFFFFFF)? SYS_ERROR():dwPos;
}

//*****************************************************************************
//*
//*     SysTell
//*
//*****************************************************************************/
//  return the file position or an error code below zero
SYS_API int SysTell(SysFile hHandle)
{
DWORD               dwPos;
HANDLE              hFile;



    hFile = SYS_GET_HANDLE(hHandle);
    dwPos = SetFilePointer(hFile,0,0,FILE_CURRENT);


return (dwPos==0xFFFFFFFF)? SYS_ERROR():dwPos;
}

//*****************************************************************************
//*
//*     SysSetFileSize
//*
//*****************************************************************************
SYS_API int SysSetFileSize(SysFile hHandle,SysDW ulSize)
{
DWORD       dwPos;
HANDLE      hFile;
int         iErr;
int         iOk;


    hFile = SYS_GET_HANDLE(hHandle);
    dwPos = SetFilePointer(hFile,0,0,FILE_CURRENT);

    SetFilePointer(hFile,ulSize,0,FILE_BEGIN);
    iOk=SetEndOfFile(hFile);

    if(!iOk)
        {
        iErr=SYS_ERROR();
        }
    else{
        iErr=0;
        }

    SetFilePointer(hFile,dwPos,0,FILE_BEGIN);



return iErr;
}


//*****************************************************************************
//*
//*     SysRead
//*
//*****************************************************************************/
//  read data from a file
//  hHandle : file handle
//  pBuffer : buffer for read
//  ulSize  : byte count
//  return the count of read bytes or an error code below zero
SYS_API int SysRead(SysFile hHandle,void *pBuffer,SysDW ulSize)
{
HANDLE      hFile;
DWORD       dwByte;


    hFile = SYS_GET_HANDLE(hHandle);

    if(!ReadFile(hFile,pBuffer,ulSize,&dwByte,NULL))
        {
        return SYS_ERROR();
        }

return dwByte;
}


//*****************************************************************************
//*
//*     SysWrite
//*
//*****************************************************************************/
//  write data to a file
//  hHandle : file handle
//  pBuffer : buffer to write
//  ulSize  : byte count
//  return the count of read bytes or an error code below zero
SYS_API int SysWrite(SysFile hHandle,const void *pBuffer,SysDW ulSize)
{
HANDLE      hFile;
DWORD       dwByte;


    hFile = SYS_GET_HANDLE(hHandle);

    if(!WriteFile(hFile,pBuffer,ulSize,&dwByte,NULL))
        {
        return SYS_ERROR();
        }



return dwByte;
}


//*****************************************************************************
//*
//*     SysGetFileSize
//*
//*****************************************************************************/
//  returns the file size or an error code below zero
SYS_API int SysGetFileSize(SysFile hHandle)
{
HANDLE      hFile;
DWORD       ulSize;


    hFile  = SYS_GET_HANDLE(hHandle);
    ulSize = GetFileSize(hFile,0);

return (ulSize==0xFFFFFFFF)? SYS_ERROR():ulSize;
}


//*****************************************************************************
//*
//*     SysGetFileInfo
//*
//*****************************************************************************/
//  search for the next file
//  hHandle : find handle
//  pFind   : pointer to file structer
//  returns 0 if a file was found or an error code below zero
SYS_API int SysGetFileInfo(SysFile hHandle,SysFindStruct *pFind)
{
BY_HANDLE_FILE_INFORMATION  sInfo;
IO_STATUS_BLOCK_			sBlock;
FILE_NAME_INFORMATION_		sData;
ULONG						uRet;
ULONG						uPos;
ULONG						uOut;
HANDLE						hFile;
int							iAttr;


    hFile  = SYS_GET_HANDLE(hHandle);

    if(!GetFileInformationByHandle(hFile,&sInfo))
        {
        return SYS_ERROR();
        }


	if(hNtDll==0)
		{
		hNtDll = GetModuleHandle("NTDLL");
		}

	if(hNtDll && !pNtQueryInformationFile)
		{
		pNtQueryInformationFile = (NtQueryInformationFileType)GetProcAddress(hNtDll,"NtQueryInformationFile");
		}


	sData.uFileNameLength	= 0;
	sData.aFileName[0]		= 0;

	if(pNtQueryInformationFile)
		{
		uRet = pNtQueryInformationFile(hFile,&sBlock,&sData,sizeof(sData),9);	// FileNameInformation
		}

	uPos = (sData.aFileName[0]=='\\')? 1:0;
	sData.uFileNameLength /= 2;

	for(uOut=0;uOut<sizeof(pFind->cName)-1;uPos++,uOut++)
		{
		if(uPos>=sData.uFileNameLength)break;
		if(sData.aFileName[uPos]<255)
			{
			pFind->cName[uOut] = (char)sData.aFileName[uPos];
			}
		else{
			pFind->cName[uOut] = '\xFF';
			}
		}

    pFind->cName[uOut] = 0;

    #if SYS_HAS_SHORT_NAME
    pFind->cShortName[0]=0;
    #endif



    iAttr=(sInfo.dwFileAttributes&FILE_ATTRIBUTE_READONLY)? SYS_READ:SYS_READ|SYS_WRITE;
    if(sInfo.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN   )iAttr|=SYS_HIDDEN;
    if(sInfo.dwFileAttributes&FILE_ATTRIBUTE_SYSTEM   )iAttr|=SYS_SYSTEM;
    if(sInfo.dwFileAttributes&FILE_ATTRIBUTE_ARCHIVE  )iAttr|=SYS_ARCHIVE;
    if(sInfo.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)iAttr|=SYS_DIR;

    pFind->dwAttr=iAttr;
    pFind->dwSize=sInfo.nFileSizeLow;

    SysTimeConvertFS(&sInfo.ftCreationTime  ,&pFind->dwTimeCreate);
    SysTimeConvertFS(&sInfo.ftLastWriteTime ,&pFind->dwTimeWrite );
    SysTimeConvertFS(&sInfo.ftLastAccessTime,&pFind->dwTimeAccess);


return 0;
}




//*****************************************************************************
//*
//*     SysMkdir
//*
//*****************************************************************************/
//  create a new directory
//  return 0 if all ok
SYS_API int SysMkdir (const char *pFilename)
{

    if(CreateDirectory(pFilename,NULL))return 0;

return SYS_ERROR();
}


//*****************************************************************************
//*
//*     SysRmdir
//*
//*****************************************************************************/
//  remove a new directory
//  return 0 if all ok
SYS_API int SysRmdir (const char *pFilename)
{

    if(RemoveDirectory(pFilename))return 0;

return SYS_ERROR();
}

//*****************************************************************************
//*
//*     SysDelete
//*
//*****************************************************************************/
//  delets a file
//  return 0 if all ok
SYS_API int SysDelete(const char *pFilename)
{

    if(DeleteFile(pFilename))return 0;

return SYS_ERROR();
}

//******************************************************************************
//*
//*     SysMove
//*
//******************************************************************************
//  moves or renames a file
SYS_API int SysMove(const char *pFilename,const char *pNewFilename)
{

    if(MoveFile(pFilename,pNewFilename))return 0;

return SYS_ERROR();
}


//*****************************************************************************
//*
//*     SysGetAttributes
//*
//*****************************************************************************/
//  get the the attribute from a file
//  pFilename   : pointer to file name
//  return ns the attriputes or an error number below zero
//              	SYS_READ
//              	SYS_WRITE
//              	SYS_DIR
//              	SYS_HIDDEN
//              	SYS_ARCHIVE
SYS_API int SysGetAttributes(const char *pFilename)
{
int iAttr,iRet;


       iAttr=GetFileAttributes(pFilename);
    if(iAttr<0)
        {
        return SYS_ERROR();
        }

    iRet=(iAttr&FILE_ATTRIBUTE_READONLY)? SYS_READ:SYS_READ|SYS_WRITE;
    if(iAttr&FILE_ATTRIBUTE_HIDDEN   )iRet|=SYS_HIDDEN;
    if(iAttr&FILE_ATTRIBUTE_SYSTEM   )iRet|=SYS_SYSTEM;
    if(iAttr&FILE_ATTRIBUTE_ARCHIVE  )iRet|=SYS_ARCHIVE;
    if(iAttr&FILE_ATTRIBUTE_DIRECTORY)iRet|=SYS_DIR;


return iRet;
}


//*****************************************************************************
//*
//*     SysSetAttributes
//*
//*****************************************************************************/
//  set the the attribute for a file
//  pFilename   : pointer to file name
// 	dwAttr		: are the new attributes
//              	SYS_READ
//              	SYS_WRITE
//              	SYS_HIDDEN
//              	SYS_ARCHIVE
//					SYS_DIR
//  returns null if ok or an error number below zero
//					SYS_ERR_??? (a value <0)
SYS_API int SysSetAttributes(const char *pFilename,SysDW ulAttr)
{
int iAttr;


    if(ulAttr&(SYS_VOLUME|SYS_DIR))
        {
        return SYS_ERR_PARAM;
        }


    iAttr=(ulAttr&SYS_WRITE)? FILE_ATTRIBUTE_NORMAL:FILE_ATTRIBUTE_READONLY;

    if(ulAttr&SYS_HIDDEN )iAttr|=FILE_ATTRIBUTE_HIDDEN;
    if(ulAttr&SYS_SYSTEM )iAttr|=FILE_ATTRIBUTE_SYSTEM;
    if(ulAttr&SYS_ARCHIVE)iAttr|=FILE_ATTRIBUTE_ARCHIVE;


    if(!SetFileAttributes(pFilename,iAttr))
        {
        return SYS_ERROR();
        }



return 0;
}



//*****************************************************************************
//*
//*     SysFindFirstEx
//*
//*****************************************************************************/
//  search for a file
//  pFilename   : find path (with '*' and '?' )
//  pFind       : pointer to file structer
//  pError      : here the error code (below zero or 0 if ok) will be stored.
//                if this pontier is zero no error code will be stored.
//  returns a find handle or a 0 if an error occurs
SYS_API SysFind SysFindFirstEx(const char *pFilename,SysFindStruct *pFind,int *pError)
{
WIN32_FIND_DATA sFind;
HANDLE          hHandle;
int             iAttr;


    if(!pFind)
        {
        if(pError)*pError=SYS_ERR_PARAM;
        return 0;
        }

       hHandle=FindFirstFile(pFilename,&sFind);
    if(hHandle==INVALID_HANDLE_VALUE)
        {
        SysClearFindStruct(pFind);
        if(pError)*pError=SYS_ERROR();
        return 0;
        }

    strcpy(pFind->cName,sFind.cFileName);

    #if SYS_HAS_SHORT_NAME
    memcpy(pFind->cShortName,&sFind,sizeof(pFind->cShortName));
    #endif

    iAttr=(sFind.dwFileAttributes&FILE_ATTRIBUTE_READONLY)? SYS_READ:SYS_READ|SYS_WRITE;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN   )iAttr|=SYS_HIDDEN;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_SYSTEM   )iAttr|=SYS_SYSTEM;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_ARCHIVE  )iAttr|=SYS_ARCHIVE;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)iAttr|=SYS_DIR;

	pFind->dwAttr = (sFind.nFileSizeHigh<<SYS_HIGHSHIFT)|iAttr;
	pFind->dwSize =  sFind.nFileSizeLow;

    SysTimeConvertFS(&sFind.ftCreationTime  ,&pFind->dwTimeCreate);
    SysTimeConvertFS(&sFind.ftLastWriteTime ,&pFind->dwTimeWrite);
    SysTimeConvertFS(&sFind.ftLastAccessTime,&pFind->dwTimeAccess);


    if(pError)*pError=SYS_ERR_NONE;



return (SysFind)SYS_NEW_HANDLE(hHandle,"*",pError);
}

//*****************************************************************************
//*
//*     SysFindNext
//*
//*****************************************************************************/
//  search for the next file
//  hHandle : find handle
//  pFind   : pointer to file structer
//  returns 0 if a file was found or an error code below zero
SYS_API int SysFindNext(SysFind hHandle,SysFindStruct *pFind)
{
WIN32_FIND_DATA sFind;
HANDLE          hFind;
int             iAttr;


    if(!pFind || !hHandle)
        {
        SysClearFindStruct(pFind);
        return SYS_ERR_PARAM;
        }

    hFind = SYS_GET_HANDLE(hHandle);

    if(!FindNextFile(hFind,&sFind))
        {
        SysClearFindStruct(pFind);
        return SYS_ERROR();
        }

    strcpy(pFind->cName,sFind.cFileName);

    #if SYS_HAS_SHORT_NAME
    memcpy(pFind->cShortName,&sFind,sizeof(pFind->cShortName));
    #endif


    iAttr=(sFind.dwFileAttributes&FILE_ATTRIBUTE_READONLY)? SYS_READ:SYS_READ|SYS_WRITE;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN   )iAttr|=SYS_HIDDEN;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_SYSTEM   )iAttr|=SYS_SYSTEM;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_ARCHIVE  )iAttr|=SYS_ARCHIVE;
    if(sFind.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)iAttr|=SYS_DIR;

	pFind->dwAttr = (sFind.nFileSizeHigh<<SYS_HIGHSHIFT)|iAttr;
	pFind->dwSize =  sFind.nFileSizeLow;

    SysTimeConvertFS(&sFind.ftCreationTime  ,&pFind->dwTimeCreate);
    SysTimeConvertFS(&sFind.ftLastWriteTime ,&pFind->dwTimeWrite);
    SysTimeConvertFS(&sFind.ftLastAccessTime,&pFind->dwTimeAccess);



return 0;
}

//*****************************************************************************
//*
//*     SysFindClose
//*
//*****************************************************************************/
SYS_API int SysFindClose(SysFind hHandle)
{
HANDLE      hFind;


    if(!hHandle)
        {
        return SYS_ERR_PARAM;
        }


    hFind = SYS_GET_HANDLE(hHandle);
            SYS_DEL_HANDLE(hHandle);

    if(!FindClose(hFind))return SYS_ERROR();


return 0;
}


//*****************************************************************************
//*
//*     SysGetFileTime
//*
//*****************************************************************************/
//  get the all times of a opened file
SYS_API int SysGetFileTime(SysFile hHandle,SysTime *pWrite,SysTime *pCreate,SysTime *pAccess)
{
HANDLE      hFile;
FILETIME    sCreationTime;
FILETIME    sLastWriteTime;
FILETIME    sLastAccessTime;


    hFile =  SYS_GET_HANDLE(hHandle);


    if(!GetFileTime(hFile,&sCreationTime,&sLastAccessTime,&sLastWriteTime))
        {
        return SYS_ERROR();
        }


    SysTimeConvertFS(&sLastWriteTime ,pWrite );
    SysTimeConvertFS(&sCreationTime  ,pCreate);
    SysTimeConvertFS(&sLastAccessTime,pAccess);


return 0;
}


//*****************************************************************************
//*
//*     SysSetFileTime
//*
//*****************************************************************************/
//  get the all times of an opened file
SYS_API int SysSetFileTime(SysFile hHandle,SysTime dwWrite,SysTime dwCreate,SysTime dwAccess)
{
HANDLE      hFile;
FILETIME    sCreationTime;
FILETIME    sLastWriteTime;
FILETIME    sLastAccessTime;


    if(!dwWrite)return 0;


    hFile =  SYS_GET_HANDLE(hHandle);


    SysTimeConvertSF(dwWrite ,&sLastWriteTime );
    SysTimeConvertSF(dwCreate,&sCreationTime  );
    SysTimeConvertSF(dwAccess,&sLastAccessTime);


    if(!SetFileTime(hFile,(dwCreate)? &sCreationTime:NULL,(dwAccess)? &sLastAccessTime:NULL,&sLastWriteTime))
        {
        return SYS_ERROR();
        }



return 0;
}


//*****************************************************************************
//*
//*     SysGetVolumeInfo
//*
//*****************************************************************************/
//  get info from a disk
//  pFilename   : name of the disk eg. "C:\"
//  pInfo       : pointer to the info stucture
//  iCalcFree   : should the free space be calculated
//  return 0 or an error code below zero
SYS_API int SysGetVolumeInfo(const char *pFilename,SysVolumeInfo *pInfo,int iCalcFree)
{
char    cName[4]="A:\\";


    if(!pInfo)
        {
        return SYS_ERR_PARAM;
        }

    if(pFilename[1]!=':')
        {
        memset(pInfo,0,sizeof(SysVolumeInfo));
        return SYS_ERROR();
        }

    cName[0] = pFilename[0];

    if(!GetDiskFreeSpace(cName,(LPDWORD)&pInfo->dwSectorsPerUnit,(LPDWORD)&pInfo->dwBytesPerSector,(LPDWORD)&pInfo->dwFreeUnits,(LPDWORD)&pInfo->dwTotalUnits))
        {
        memset(pInfo,0,sizeof(SysVolumeInfo));
        return SYS_ERROR();
        }

    if(!GetVolumeInformation(cName,pInfo->cName,sizeof(pInfo->cName),(LPDWORD)&pInfo->dwSerialNumber,NULL,NULL,pInfo->cFsType,sizeof(pInfo->cFsType)))
        {
        memset(pInfo,0,sizeof(SysVolumeInfo));
        return SYS_ERROR();
        }

    if(!iCalcFree)pInfo->dwFreeUnits=0;



return 0;
}

//*****************************************************************************
//*
//*     SysSemaphoreCreate
//*
//*****************************************************************************/
SYS_API SysSemaphore SysSemaphoreCreate()
{
return CreateSemaphore(0,1,0x70000000,0);
}

//*****************************************************************************
//*
//*     SysSemaphoreCreateEx
//*
//*****************************************************************************/
SYS_API SysSemaphore SysSemaphoreCreateEx(int iNumber)
{
return CreateSemaphore(0,iNumber,0x70000000,0);
}

//*****************************************************************************
//*
//*     SysSemaphoreDelete
//*
//*****************************************************************************/
SYS_API int SysSemaphoreDelete(SysSemaphore hSemaphore)
{
return  CloseHandle(hSemaphore);
}


//*****************************************************************************
//*
//*     SysSemaphoreUnlock
//*
//*****************************************************************************/
SYS_API int SysSemaphoreUnlock(SysSemaphore hSemaphore)
{

    ReleaseSemaphore(hSemaphore,1,0);

return 1;
}


//*****************************************************************************
//*
//*     SysSemaphoreLock
//*
//*****************************************************************************/
SYS_API int SysSemaphoreLock(SysSemaphore hSemaphore)
{

    WaitForSingleObject(hSemaphore,INFINITE);

return 1;
}


//*****************************************************************************
//*
//*     SysSemaphoreLockWait
//*
//*****************************************************************************/
//  return  0: Timeout
//          1: Unlock
SYS_API int SysSemaphoreLockWait(SysSemaphore hSemaphore,SysDW dwMillisec)
{
return (WaitForSingleObject(hSemaphore,dwMillisec)==WAIT_OBJECT_0)? 1:0;
}


//*****************************************************************************
//*
//*     SysSleep
//*
//*****************************************************************************/
//  suspents the current thread for some time
//  dwMillisec      : is the time in millisekonds
SYS_API void SysSleep(SysDW dwMillisec)
{
    Sleep(dwMillisec);
}

//*****************************************************************************
//*
//*     SysTickCount
//*
//*****************************************************************************
//  Holt den aktuellen Systemtick in ms
SYS_API SysDW SysTickCount()
{
return GetTickCount();
}

//*****************************************************************************
//*
//*     SysThreadProc
//*
//*****************************************************************************/
static void volatile ( _cdecl *pStartProc)(void*)=0;
static DWORD _stdcall SysThreadProc(LPVOID pParam)
{
ThreadData  sData;


    memcpy(&sData,pParam,sizeof(sData));
    delete pParam;

    SetThreadPriority(GetCurrentThread(),aPrio[sData.iPrior]);
    sData.pProc(sData.pParam);
    CloseHandle(GetCurrentThread());


return 0;
}

//*****************************************************************************
//*
//*     SysThreadStart
//*
//*****************************************************************************
//  start a new thread
//  pStartProc  : function fpr the thread
//  dwStackSize : count of bytes for stack
//  pParam      : Parameter for pStartProc
//  iPriority   : -256 to 256 relative to the current priority or
//                SYS_GLOBAL|priority for a global priority
//  pName       : taskname
//  returns the thread handle
SYS_API SysThread SysThreadStart(void(_cdecl *pStartProc)(void*),SysDW dwStackSize,void *pParam,int iPriority,const char *pName)
{
ThreadData *pData;
HANDLE		hTask;
DWORD       ulId;
int         i;



	if(!dwStackSize)return 0;


    if((iPriority&0xFFFF0000)==SYS_GLOBAL)
        {
        iPriority &= 0xFFFF;
        }
    else{
        for(i=0;i<6;i++)
            {
            if(iPriority>=aPrio[i])break;
            }

        iPriority  = GetThreadPriority(GetCurrentThread());
        iPriority += i*73;
        }

       iPriority+=256;
       iPriority/=73;
    if(iPriority<0)iPriority=0;
    if(iPriority>7)iPriority=6;


        pData = new ThreadData;
    if(!pData)return 0;

    pData->pProc    = pStartProc;
    pData->pName    = pName;
    pData->pParam   = pParam;
    pData->iPrior   = iPriority;

	hTask = CreateThread(0,dwStackSize,SysThreadProc,pData,0,&ulId);
	
	CloseHandle(hTask);
	
	

return hTask;
}

//*****************************************************************************
//*
//*     HeapAllocD
//*
//*****************************************************************************
#ifdef  HEAP_DEBUG
#define      MAX_ALLOCS 0x1000
char         cHeapNames [MAX_ALLOCS][28];
void        *pHeapPoints[MAX_ALLOCS];
unsigned     uHeapSizes [MAX_ALLOCS];
HANDLE       hHeapSemaphore=0;
int          dwHeapCount=0;
int          dwHeapSize=0;
int          dwHeapMax=0;

void   *HeapAllocD(void *hHeap,SysDW dwFlags,SysDW dwBytes,int iLine,const char *pFile)
{
void    *pMem;
char    *pData;
int      i;

    if(!hHeapSemaphore)
        {
        hHeapSemaphore=CreateSemaphore(0,1,0x70000000,0);
        }

        pMem=HeapAlloc(hHeap,dwFlags,dwBytes);
    if(!pMem)return 0;

    WaitForSingleObject(hHeapSemaphore,INFINITE);
    dwHeapCount++;
    for(i=0;i<MAX_ALLOCS;i++)if(!pHeapPoints[i])break;
    if(i<MAX_ALLOCS){pHeapPoints[i]=pMem;}
    ReleaseSemaphore(hHeapSemaphore,1,0);

    if(i<MAX_ALLOCS)
        {
        uHeapSizes[i]=dwBytes;
        pData=cHeapNames[i];
        WaitForSingleObject(hHeapSemaphore,INFINITE);
        dwHeapSize+=dwBytes;
        ReleaseSemaphore(hHeapSemaphore,1,0);

        i=strlen(pFile);
        for(;i>0;i--)
            {
            if(pFile[i]=='\\'){i++;break;}
            if(pFile[i]=='/' ){i++;break;}
            }
        _snprintf(pData,28,"%s(%i)",pFile+i,iLine);
        pData[27]=0;
        }

    if(dwHeapSize>dwHeapMax)dwHeapMax=dwHeapSize;


return pMem;
}


//*****************************************************************************
//*
//*     HeapReAllocD
//*
//*****************************************************************************
void *HeapReAllocD(void *hHeap,SysDW dwFlags,void *pOldMem,SysDW dwBytes,int iLine,const char *pFile)
{
void    *pMem;
char    *pData;
int      i;


    if(!pOldMem)return 0;

    if(!hHeapSemaphore)
        {
        hHeapSemaphore=CreateSemaphore(0,1,0x70000000,0);
        }

        pMem=HeapReAlloc(hHeap,dwFlags,pOldMem,dwBytes);
    if(!pMem)return 0;

    WaitForSingleObject(hHeapSemaphore,INFINITE);
    for(i=0;i<MAX_ALLOCS;i++)if(pHeapPoints[i]==pOldMem)break;
    if(i<MAX_ALLOCS){pHeapPoints[i]=pMem;}
    ReleaseSemaphore(hHeapSemaphore,1,0);

    if(i<MAX_ALLOCS)
        {
        WaitForSingleObject(hHeapSemaphore,INFINITE);
        dwHeapSize-=uHeapSizes[i];
        dwHeapSize+=dwBytes;
        ReleaseSemaphore(hHeapSemaphore,1,0);
        uHeapSizes[i]=dwBytes;
        pData=cHeapNames[i];

        i=strlen(pFile);
        for(;i>0;i--)
            {
            if(pFile[i]=='\\'){i++;break;}
            if(pFile[i]=='/' ){i++;break;}
            }
        _snprintf(pData,28,"%s(%i)",pFile+i,iLine);
        pData[27]=0;
        }

    if(dwHeapSize>dwHeapMax)dwHeapMax=dwHeapSize;


return pMem;
}


//*****************************************************************************
//*
//*     HeapFreeD
//*
//*****************************************************************************
int HeapFreeD(void *hHeap,SysDW dwFlags,void *pMem,int iLine,const char *pFile)
{
char    *pData=(char*)pMem;
int      i;


    if(!pMem)
        return 0;

    WaitForSingleObject(hHeapSemaphore,INFINITE);
    dwHeapCount--;
    ReleaseSemaphore(hHeapSemaphore,1,0);

    for(i=0;i<MAX_ALLOCS;i++)if(pHeapPoints[i]==pMem)break;
    if(i<MAX_ALLOCS)
        {
        WaitForSingleObject(hHeapSemaphore,INFINITE);
        dwHeapSize-=uHeapSizes[i];
        ReleaseSemaphore(hHeapSemaphore,1,0);
        cHeapNames [i][0]=0;
        pHeapPoints[i]=0;
        uHeapSizes [i]=0;
        }


return HeapFree(hHeap,dwFlags,pMem);
}

//*****************************************************************************
//*
//*     HeapPrint
//*
//*****************************************************************************
int HeapPrint()
{
char    *pData;
int      i;


    SysSleep(500);

    #ifdef NO_PRINT
    printf("\nHEAP COUNT = %i   size=%i  max=%i",dwHeapCount,dwHeapSize,dwHeapMax);
    #else
    //nprintf("\nHEAP COUNT = %i   size=%i  max=%i",dwHeapCount,dwHeapSize,dwHeapMax);
    #endif

    for(i=0;i<MAX_ALLOCS;i++)
        {
        if(!pHeapPoints[i])continue;
        pData=cHeapNames[i];
        #ifdef NO_PRINT
        printf("\n   %08X --> \"%s\" = %i",pHeapPoints[i],pData,uHeapSizes[i]);
        #else
        //nprintf("\n   %08X --> \"%s\" = %i",pHeapPoints[i],pData,uHeapSizes[i]);
        #endif
        }

    SysSleep(300);


return dwHeapCount;
}
#endif


