//*****************************************************************************
//*
//*
//*      Smb.h
//*
//*
//*****************************************************************************
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#ifndef     __SMB_H__
#define     __SMB_H__

#include    "System/SocketUtility.h"
#include    "System/System.h"
#include    "NetBiosDebug.h"
#include    "SmbServer.h"

#define     SMB_BASE                0x424D53FF  // the "\xFFSMB" tag
#define     SMB_SECONDARY_WAIT      (1*60*1000) // timeout for secontary read in ms
#define     SMB_PROCESS_TIMEOUT     (2*60*1000) // timeout for proccess  in ms

#ifndef		SMB_OS
#define     SMB_OS                  "Maemo 5"
#endif 	
#define     SMB_API                 extern "C"
#define     SMB_SERVER              "AZ-Smb 1.08"

#define     SMB_SHARE               0
#define     SMB_USER                1

#define     SMB_MODE_VIEWSHARES     0
#define     SMB_MODE_READONLY       1
#define     SMB_MODE_READWRITE      2

#define     PROTOCOL_CORE           0
#define     PROTOCOL_COREPLUS       1
#define     PROTOCOL_LANMAN1        2
#define     PROTOCOL_LANMAN2        3
#define     PROTOCOL_NT1            4



//******************** Debug Macros *******************************************

#if SMB_PRINT
    #define     PRINT_SMB_LOCK()    smb_plock();
    #define     PRINT_SMB_UNLOCK()  smb_punlock();
    #define     PRINT_SMB_STATE(a)  smb_printf a;
    #define     PRINT_SMB_MSG(a)    smb_printf a;
    #define     PRINT_SMB_MSG1(a)   smb_printf a;
    #define     PRINT_SMB_MSG2(a)
    #define     PRINT_SMB_ERR(a)    smb_printf a;
    #define     PRINT_SMB_ERRS(a)   smb_printf a;
    #define     PRINT_SMB_LANM(a)   smb_printf a;
    #define     PRINT_SMB_LERR(a)   smb_printf a;
    #define     PRINT_SMB_LANM_ON   1
#else
    #define     PRINT_SMB_LOCK()
    #define     PRINT_SMB_UNLOCK()
    #define     PRINT_SMB_STATE(a)
    #define     PRINT_SMB_MSG(a)
    #define     PRINT_SMB_MSG1(a)
    #define     PRINT_SMB_MSG2(a)
    #define     PRINT_SMB_ERR(a)
    #define     PRINT_SMB_ERRS(a)
    #define     PRINT_SMB_LANM(a)
    #define     PRINT_SMB_LERR(a)
    #define     PRINT_SMB_LANM_ON   0
#endif

//******************** Stuctueres *********************************************

struct  SmbSessionS;

typedef void *SmbBase;

typedef struct
    {
    unsigned int    uFlen;                          // lenght off filter name
    unsigned char   uPos;                           // seach position
    char            cFiler[MAX_BASENAME_SIZE];      // filter name
    }SmbBaseEntry;

typedef struct
    {
    union
        {
        SysFile     hFile;                          // used file handle
        SysFind     hFind;                          // used find handle
        SmbBase     hBase;                          // used basefind handle
        };
    unsigned int    ulUser;                         // user word
    unsigned char   bType;                          // type of handle (0=file 1=find 2=base)
    }SmbFileEntry;

typedef struct
    {
    char            cUsername[MAX_USERNAME_SIZE];   // username
    const char     *pPath    [MAX_TREE_SHARES];     // paths of tree entries
    const char     *pService [MAX_TREE_SHARES];     // names of tree entries
    const char     *pComment [MAX_TREE_SHARES];     // paths of tree entries
    char            cMode    [MAX_TREE_SHARES];     // are the path read only
    void           *pMem     [MAX_TREE_SHARES];     // are memory poiners
    int             iCount;                         // count of names and paths
    int             iPasswordOk;                    // is the password checked
    }SmbUserEntry;

typedef struct
    {
    int             iConnect;                       // nummber off tree ressource
    int             iConnectLen;                    // length off path
    int             iConnectType;                   // 0=Path 1=Pipe 4=Base
    int             iOnlyShareAccess;               // the user can only view shares
    int             iAddPathLen;                    // lenght off path to add
    char            cAddPath[MAX_PATHNAME_SIZE];    // path to add
    unsigned short  wUidFixed;                      // current user id static
    char            bReadOnly;                      // are paths readonly
    SmbUserEntry   *pUser;                          // pointer to user
    SmbBaseEntry    sBaseEntry[MAX_BASE_ENTRIES];   // base find entries
    SmbFileEntry    sFileEntry[MAX_FILE_ENTRIES];   // file entries
    char            cBaseEntryBits[(MAX_USER_ENTRIES+7)/8];
    char            cFileEntryBits[(MAX_FILE_ENTRIES+7)/8];
    }SmbTreeEntry;

typedef struct
    {
    int             iProtocol;                      // selected protocol
    char            cRemoteMachine[16];             // name of client
    char            cLocalMachine [16];             // name of erver
    int             iLMLen;                         // lenght of cLocalMachine
    unsigned        uProcessNumber;                 // number of the process
    unsigned int    ulId;                           // session id
    unsigned short  wFid;                           // current file id
    unsigned short  wUid;                           // current user id
    unsigned short  wTid;                           // current tree id
    unsigned short  wPid;                           // current process id
    SmbFileEntry   *pFile;                          // current file
    SmbTreeEntry   *pTree;                          // current tree
    SmbUserEntry   *pUser;                          // current user
    TcpHandle       hTcp;                           // tcp handle
    int             iNumber;                        // process number
    int             iPacketCount;                   // count of the recived packets
    int             iCurrentPacket;                 // current handlet packet
    int             iState;                         // current state
    int             iMaxResvSize;                   // maximum size from recive buffer
    int             iChainSize;                     // size of a chain
    unsigned char  *pChainOut;                      // start of a chain input buffer
    unsigned char  *pChainIn;                       // start of a chain output buffer
    unsigned char   bChallenge[8];                  // enchryption key
    int             bEncrypt;                       // password encryption
    int             iSecurityMode;                  // security mode (1=user 0=share)
    SmbTreeEntry    sTreeEntry    [ MAX_TREE_ENTRIES];
    SmbUserEntry    sUserEntry    [ MAX_USER_ENTRIES];
    char            cTreeEntryBits[(MAX_TREE_ENTRIES+7)/8];
    char            cUserEntryBits[(MAX_USER_ENTRIES+7)/8];
    }SmbSession;



#ifdef _MSC_VER
#pragma pack (push)
#pragma pack (1)
#endif

#if __GNUC__ > 3
#define PACKED   __attribute__((__packed__,aligned(1)))
#else
#define PACKED
#endif

typedef struct
    {
    unsigned int    ulLen;                          // packet length
    unsigned char   bId[4];                         // contains 0xFF,'SMB'
    unsigned char   bCom;                           // command code
    unsigned char   bErrcls;                        // error class
    unsigned char   bRes1;                          // reserved for future
    unsigned short  wError;                         // error code
    unsigned char   bFlag;                          // flags
    unsigned short  wRes1[7];                       // reserved for future
    unsigned short  wTid;                           // authenticated resource identifier
    unsigned short  wPid;                           // caller's process id
    unsigned short  wUid;                           // unauthenticated user id
    unsigned short  wMid;                           // multiplex id
    unsigned char   bWordCount;                     // count of 16-bit words that follow
    unsigned short  wWords[7];                      // variable number of 16-bit words
    }PACKED SmbPacketHeader;



#ifdef _MSC_VER
#pragma pack(pop)
#endif


//*****************************************************************************

#define CVAL(buf,pos)       (((unsigned char *)(buf))[pos])
#define PVAL(buf,pos)       ((unsigned)CVAL(buf,pos))
#define SCVAL(buf,pos,val)  (CVAL(buf,pos) = (val))

#define SVAL(buf,pos)       (*(unsigned short *)((char *)(buf) + (pos)))
#define IVAL(buf,pos)       (*(unsigned int   *)((char *)(buf) + (pos)))
#define SVALS(buf,pos)      (*(         short *)((char *)(buf) + (pos)))
#define IVALS(buf,pos)      (*(         int   *)((char *)(buf) + (pos)))

#define BITSETB(ptr,bit)    ((((char *)ptr)[0] & (1<<(bit)))!=0)
#define BITSETW(ptr,bit)    ((SVAL(ptr,0) & (1<<(bit)))!=0)

#define PTR_DIFF(p1,p2)     ((int)(((const char *)(p1)) - (const char *)(p2)))

// store single value in an SMB buffer

#define SSVAL(buf,pos,val)  SVAL(buf,pos)=((unsigned short )(val))
#define SIVAL(buf,pos,val)  IVAL(buf,pos)=((unsigned int   )(val))
#define SSVALS(buf,pos,val) SVALS(buf,pos)=((        short )(val))
#define SIVALS(buf,pos,val) IVALS(buf,pos)=((        int   )(val))

#define SREV(x)             ((((x)&0xFF)<<8) | (((x)>>8)&0xFF))
#define IREV(x)             ((SREV(x)<<16) | (SREV((x)>>16)))
#define RSVAL(buf,pos)      SREV(SVAL(buf,pos))


#ifdef  MIN
#undef  MIN
#endif
#define MIN(a,b) ((a)<(b)?(a):(b))

#ifdef  MAX
#undef  MAX
#endif
#define MAX(a,b) ((a)>(b)?(a):(b))

#ifdef _MSC_VER

    #pragma warning( disable :4100 )
    #pragma warning( disable :4127 )
    #pragma warning( disable :4201 )
    #pragma warning( disable :4211 )
    #pragma warning( disable :4514 )
    #pragma warning( disable :4702 )
    #pragma warning( disable :4996 )

    typedef unsigned __int64    smb_ulong64;
    typedef          __int64    smb_long64;

#elif defined(__GNUC__)

    typedef unsigned long long  smb_ulong64;
    typedef          long long  smb_long64;

#else

    #error unknown compiler

#endif



#define smb_len(buf)        (PVAL(buf,3)|(PVAL(buf,2)<<8)|((PVAL(buf,1)&1)<<16))
#define smb_base(buf)       (((char*)(buf))+4)
#define smb_buf(buf)        (buf + smb_size + CVAL(buf,smb_wct)*2)
#define smb_buflen(buf)     (SVAL(buf,smb_vwv0 + (int)CVAL(buf, smb_wct)*2))
#define smb_offset(p,b)     ((char*)(p)-(char*)(b)-4+pSession->iChainSize)
#define smb_len(buf)        (PVAL(buf,3)|(PVAL(buf,2)<<8)|((PVAL(buf,1)&1)<<16))

#define UID_FIELD_INVALID   0

#define F_USER              (0x0100<<0)
#define F_FID               (0x0100<<1)
#define F_FID2              (F_FID+2*2)
#define F_WRITE             (0x0100<<2)
#define CAN_IPC             (0x0100<<3)
#define AS_GUEST            (0x0100<<5)
#define SMB_SUCCESS         0                   // The request was successful.


#define smb_size    39                          // the basic packet size, assuming no words or bytes

// offsets into message for common items

#define smb_idf     4
#define smb_com     8
#define smb_rcls    9
#define smb_reh     10
#define smb_err     11
#define smb_flg     13
#define smb_flg2    14
#define smb_reb     13
#define smb_tid     28
#define smb_pid     30
#define smb_uid     32
#define smb_mid     34
#define smb_wct     36
#define smb_vwv     37
#define smb_vwv0    37
#define smb_vwv1    39
#define smb_vwv2    41
#define smb_vwv3    43
#define smb_vwv4    45
#define smb_vwv5    47
#define smb_vwv6    49
#define smb_vwv7    51
#define smb_vwv8    53
#define smb_vwv9    55
#define smb_vwv10   57
#define smb_vwv11   59
#define smb_vwv12   61
#define smb_vwv13   63
#define smb_vwv14   65
#define smb_vwv15   67
#define smb_vwv16   69
#define smb_vwv17   71

// these are the trans2 sub fields for primary requests

#define smb_tpscnt  smb_vwv0
#define smb_tdscnt  smb_vwv1
#define smb_mprcnt  smb_vwv2
#define smb_mdrcnt  smb_vwv3
#define smb_msrcnt  smb_vwv4
#define smb_flags   smb_vwv5
#define smb_timeout smb_vwv6
#define smb_pscnt   smb_vwv9
#define smb_psoff   smb_vwv10
#define smb_dscnt   smb_vwv11
#define smb_dsoff   smb_vwv12
#define smb_suwcnt  smb_vwv13
#define smb_setup   smb_vwv14
#define smb_setup0  smb_setup
#define smb_setup1 (smb_setup+2)
#define smb_setup2 (smb_setup+4)

// these are for the secondary requests
#define smb_spscnt  smb_vwv2
#define smb_spsoff  smb_vwv3
#define smb_spsdisp smb_vwv4
#define smb_sdscnt  smb_vwv5
#define smb_sdsoff  smb_vwv6
#define smb_sdsdisp smb_vwv7
#define smb_sfid    smb_vwv8

// and these for responses

#define smb_tprcnt  smb_vwv0
#define smb_tdrcnt  smb_vwv1
#define smb_prcnt   smb_vwv3
#define smb_proff   smb_vwv4
#define smb_prdisp  smb_vwv5
#define smb_drcnt   smb_vwv6
#define smb_droff   smb_vwv7
#define smb_drdisp  smb_vwv8

// Responses when opening a file.

#define FILE_WAS_OPENED                     1
#define FILE_WAS_CREATED                    2
#define FILE_WAS_OVERWRITTEN                3

// flag defines. CIFS spec 3.1.1

#define FLAG_SUPPORT_LOCKREAD               0x01
#define FLAG_CLIENT_BUF_AVAIL               0x02
#define FLAG_RESERVED                       0x04
#define FLAG_CASELESS_PATHNAMES             0x08
#define FLAG_CANONICAL_PATHNAMES            0x10
#define FLAG_REQUEST_OPLOCK                 0x20
#define FLAG_REQUEST_BATCH_OPLOCK           0x40
#define FLAG_REPLY                          0x80

// NT Flags2 bits - cifs6.txt section 3.1.2

#define FLAGS2_LONG_PATH_COMPONENTS         0x0001
#define FLAGS2_EXTENDED_ATTRIBUTES          0x0002
#define FLAGS2_DFS_PATHNAMES                0x1000
#define FLAGS2_READ_PERMIT_NO_EXECUTE       0x2000
#define FLAGS2_32_BIT_ERROR_CODES           0x4000
#define FLAGS2_UNICODE_STRINGS              0x8000
#define FLAGS2_WIN2K_SIGNATURE              0xC852

// Capabilities.  see ftp.microsoft.com/developr/drg/cifs/cifs/cifs4.txt

#define CAP_RAW_MODE                        0x0001
#define CAP_MPX_MODE                        0x0002
#define CAP_UNICODE                         0x0004
#define CAP_LARGE_FILES                     0x0008
#define CAP_NT_SMBS                         0x0010
#define CAP_RPC_REMOTE_APIS                 0x0020
#define CAP_STATUS32                        0x0040
#define CAP_LEVEL_II_OPLOCKS                0x0080
#define CAP_LOCK_AND_READ                   0x0100
#define CAP_NT_FIND                         0x0200
#define CAP_DFS                             0x1000
#define CAP_W2K_SMBS                        0x2000
#define CAP_LARGE_READX                     0x4000
#define CAP_LARGE_WRITEX                    0x8000
#define CAP_EXTENDED_SECURITY               0x80000000

// These are the TRANS2 sub commands

#define TRANSACT2_OPEN                      0x0000
#define TRANSACT2_FINDFIRST                 0x0001
#define TRANSACT2_FINDNEXT                  0x0002
#define TRANSACT2_QFSINFO                   0x0003
#define TRANSACT2_SETFSINFO                 0x0004
#define TRANSACT2_QPATHINFO                 0x0005
#define TRANSACT2_SETPATHINFO               0x0006
#define TRANSACT2_QFILEINFO                 0x0007
#define TRANSACT2_SETFILEINFO               0x0008
#define TRANSACT2_FSCTL                     0x0009
#define TRANSACT2_IOCTL                     0x000A
#define TRANSACT2_FINDNOTIFYFIRST           0x000B
#define TRANSACT2_FINDNOTIFYNEXT            0x000C
#define TRANSACT2_MKDIR                     0x000D
#define TRANSACT2_SESSION_SETUP             0x000E
#define TRANSACT2_GET_DFS_REFERRAL          0x0010
#define TRANSACT2_REPORT_DFS_INCONSISTANCY  0x0011

#define SMB_QUERY_FILE_BASIC_INFO           0x0101
#define SMB_QUERY_FILE_STANDARD_INFO        0x0102
#define SMB_QUERY_FILE_EA_INFO              0x0103
#define SMB_QUERY_FILE_NAME_INFO            0x0104
#define SMB_QUERY_FILE_ALLOCATION_INFO      0x0105
#define SMB_QUERY_FILE_END_OF_FILEINFO      0x0106
#define SMB_QUERY_FILE_ALL_INFO             0x0107
#define SMB_QUERY_FILE_ALT_NAME_INFO        0x0108
#define SMB_QUERY_FILE_STREAM_INFO          0x0109

#define SMB_FIND_FILE_DIRECTORY_INFO        0x0101
#define SMB_FIND_FILE_FULL_DIRECTORY_INFO   0x0102
#define SMB_FIND_FILE_NAMES_INFO            0x0103
#define SMB_FIND_FILE_BOTH_DIRECTORY_INFO   0x0104

#define SMB_SET_FILE_BASIC_INFO             0x0101
#define SMB_SET_FILE_DISPOSITION_INFO       0x0102
#define SMB_SET_FILE_ALLOCATION_INFO        0x0103
#define SMB_SET_FILE_END_OF_FILE_INFO       0x0104

#define SMB_INFO_STANDARD                   0x0001
#define SMB_INFO_QUERY_EA_SIZE              0x0002
#define SMB_INFO_QUERY_EAS_FROM_LIST        0x0003
#define SMB_INFO_QUERY_ALL_EAS              0x0004
#define SMB_INFO_IS_NAME_VALID              0x0006
#define SMB_QUERY_FS_LABEL_INFO             0x0101
#define SMB_QUERY_FS_VOLUME_INFO            0x0102
#define SMB_QUERY_FS_SIZE_INFO              0x0103
#define SMB_QUERY_FS_DEVICE_INFO            0x0104
#define SMB_QUERY_FS_ATTRIBUTE_INFO         0x0105

#define SMB_FILE_DIRECTORY_INFORMATION      1001
#define SMB_FILE_FULL_DIRECTORY_INFORMATION 1002
#define SMB_FILE_BOTH_DIRECTORY_INFORMATION 1003
#define SMB_FILE_BASIC_INFORMATION          1004
#define SMB_FILE_STANDARD_INFORMATION       1005
#define SMB_FILE_INTERNAL_INFORMATION       1006
#define SMB_FILE_EA_INFORMATION             1007
#define SMB_FILE_ACCESS_INFORMATION         1008
#define SMB_FILE_NAME_INFORMATION           1009
#define SMB_FILE_RENAME_INFORMATION         1010
#define SMB_FILE_LINK_INFORMATION           1011
#define SMB_FILE_NAMES_INFORMATION          1012
#define SMB_FILE_DISPOSITION_INFORMATION    1013
#define SMB_FILE_POSITION_INFORMATION       1014
#define SMB_FILE_FULL_EA_INFORMATION        1015
#define SMB_FILE_MODE_INFORMATION           1016
#define SMB_FILE_ALIGNMENT_INFORMATION      1017
#define SMB_FILE_ALL_INFORMATION            1018
#define SMB_FILE_ALLOCATION_INFORMATION     1019
#define SMB_FILE_END_OF_FILE_INFORMATION    1020
#define SMB_FILE_ALTERNATE_NAME_INFORMATION 1021
#define SMB_FILE_STREAM_INFORMATION         1022
#define SMB_FILE_PIPE_INFORMATION           1023
#define SMB_FILE_PIPE_LOCAL_INFORMATION     1024
#define SMB_FILE_PIPE_REMOTE_INFORMATION    1025
#define SMB_FILE_MAILSLOT_QUERY_INFORMATION 1026
#define SMB_FILE_MAILSLOT_SET_INFORMATION   1027
#define SMB_FILE_COMPRESSION_INFORMATION    1028
#define SMB_FILE_OBJECTID_INFORMATION       1029
#define SMB_FILE_COMPLETION_INFORMATION     1030
#define SMB_FILE_MOVE_CLUSTER_INFORMATION   1031
#define SMB_FILE_QUOTA_INFORMATION          1032
#define SMB_FILE_REPARSEPOINT_INFORMATION   1033
#define SMB_FILE_NETWORK_OPEN_INFORMATION   1034
#define SMB_FILE_ATTRIBUTE_TAG_INFORMATION  1035
#define SMB_FILE_TRACKING_INFORMATION       1036
#define SMB_FILE_MAXIMUM_INFORMATION        1037

// the complete
#define SMBmkdir                0x00  // create directory
#define SMBrmdir                0x01  // delete directory
#define SMBopen                 0x02  // open file
#define SMBcreate               0x03  // create file
#define SMBclose                0x04  // close file
#define SMBflush                0x05  // flush file
#define SMBunlink               0x06  // delete file
#define SMBmv                   0x07  // rename file
#define SMBgetAttr              0x08  // get file attributes
#define SMBsetAttr              0x09  // set file attributes
#define SMBread                 0x0A  // read from file
#define SMBwrite                0x0B  // write to file
#define SMBlock                 0x0C  // lock byte range
#define SMBunlock               0x0D  // unlock byte range
#define SMBctemp                0x0E  // create temporary file
#define SMBmknew                0x0F  // make new file
#define SMBchkpth               0x10  // check directory path
#define SMBexit                 0x11  // process exit
#define SMBlseek                0x12  // seek
#define SMBtcon                 0x70  // tree connect
#define SMBtconX                0x75  // tree connect and X
#define SMBtdis                 0x71  // tree disconnect
#define SMBnegprot              0x72  // negotiate protocol
#define SMBdskattr              0x80  // get disk attributes
#define SMBsearch               0x81  // search directory
#define SMBsplopen              0xC0  // open print spool file
#define SMBsplwr                0xC1  // write to print spool file
#define SMBsplclose             0xC2  // close print spool file
#define SMBsplretq              0xC3  // return print queue
#define SMBsends                0xD0  // send single block message
#define SMBsendb                0xD1  // send broadcast message
#define SMBfwdname              0xD2  // forward user name
#define SMBcancelf              0xD3  // cancel forward
#define SMBgetmac               0xD4  // get machine name
#define SMBsendstrt             0xD5  // send start of multi-block message
#define SMBsendend              0xD6  // send end of multi-block message
#define SMBsendtxt              0xD7  // send text of multi-block message

// Core+ protocol

#define SMBlockread             0x13  // Lock a range and read
#define SMBwriteunlock          0x14  // Unlock a range then write
#define SMBreadbraw             0x1a  // read a block of data with no smb header
#define SMBwritebraw            0x1d  // write a block of data with no smb header
#define SMBwritec               0x20  // secondary write request
#define SMBwriteclose           0x2c  // write a file then close it

// dos extended protocol
#define SMBreadBraw             0x1A  // read block raw
#define SMBreadBmpx             0x1B  // read block multiplexed
#define SMBreadBs               0x1C  // read block (secondary response)
#define SMBwriteBraw            0x1D  // write block raw
#define SMBwriteBmpx            0x1E  // write block multiplexed
#define SMBwriteBs              0x1F  // write block (secondary request)
#define SMBwriteC               0x20  // write complete response
#define SMBsetattrE             0x22  // set file attributes expanded
#define SMBgetattrE             0x23  // get file attributes expanded
#define SMBlockingX             0x24  // lock/unlock byte ranges and X
#define SMBtrans                0x25  // transaction - name, bytes in/out
#define SMBtranss               0x26  // transaction (secondary request/response)
#define SMBioctl                0x27  // IOCTL
#define SMBioctls               0x28  // IOCTL  (secondary request/response)
#define SMBcopy                 0x29  // copy
#define SMBmove                 0x2A  // move
#define SMBecho                 0x2B  // echo
#define SMBopenX                0x2D  // open and X
#define SMBreadX                0x2E  // read and X
#define SMBwriteX               0x2F  // write and X
#define SMBsesssetupX           0x73  // Session Set Up & X (including User Logon)
#define SMBffirst               0x82  // find first
#define SMBfunique              0x83  // find unique
#define SMBfclose               0x84  // find close
#define SMBinvalid              0xFE  // invalid command

// Extended 2.0 protocol

#define SMBtrans2               0x32  // TRANS2 protocol set
#define SMBtranss2              0x33  // TRANS2 protocol set, secondary command
#define SMBfindclose            0x34  // Terminate a TRANSACT2_FINDFIRST
#define SMBfindnclose           0x35  // Terminate a TRANSACT2_FINDNOTIFYFIRST
#define SMBulogoffX             0x74  // user logoff

// NT SMB extensions.

#define SMBnttrans              0xA0  // NT transact
#define SMBnttranss             0xA1  // NT transact secondary
#define SMBntcreateX            0xA2  // NT create and X
#define SMBntcancel             0xA4  // NT cancel

// Error classes

#define ERRDOS                  0x01  // Error is from the core DOS operating system set.
#define ERRSRV                  0x02  // Error is generated by the server network file manager.
#define ERRHRD                  0x03  // Error is an hardware error.
#define ERRCMD                  0xFF  // Command was not in the "SMB" format.


// SMB X/Open error codes for the ERRDOS error class

#define ERRsuccess              0     // No error
#define ERRbadfunc              1     // Invalid function (or system call)
#define ERRbadfile              2     // File not found (pathname error)
#define ERRbadpath              3     // Directory not found
#define ERRnofids               4     // Too many open files
#define ERRnoaccess             5     // Access denied
#define ERRbadfid               6     // Invalid fid
#define ERRbadmcb               7     // Memory control blocks destroyed.
#define ERRnomem                8     // Out of memory
#define ERRbadmem               9     // Invalid memory block address
#define ERRbadenv               10    // Invalid environment
#define ERRbadaccess            12    // Invalid open mode
#define ERRbaddata              13    // Invalid data (only from ioctl call)
#define ERRres                  14    // reserved
#define ERRbaddrive             15    // Invalid drive
#define ERRremcd                16    // Attempt to delete current directory
#define ERRdiffdevice           17    // rename/move across different filesystems
#define ERRnofiles              18    // no more files found in file search
#define ERRbadshare             32    // Share mode on file conflict with open mode
#define ERRlock                 33    // Lock request conflicts with existing lock
#define ERRunsup                50    // Request unsupported, returned by Win 95, RJS 20Jun98
#define ERRnoipc                66    // don't support ipc
#define ERRnosuchshare          67    // You specified an invalid share name
#define ERRfilexists            80    // File in operation already exists
#define ERRinvalidparam         87    // Invalid parameter
#define ERRcannotopen           110   // Cannot open the file specified
#define ERRinsufficientbuffer   122
#define ERRinvalidname          123   // Invalid name
#define ERRunknownlevel         124
#define ERRnotlocked            158   // This region is not locked by this locking context.
#define ERRrename               183
#define ERRbadpipe              230   // Named pipe invalid
#define ERRpipebusy             231   // All instances of pipe are busy
#define ERRpipeclosing          232   // named pipe close in progress
#define ERRnotconnected         233   // No process on other end of named pipe
#define ERRmoredata             234   // More data to be returned
#define ERRnomoreitems          259
#define ERRbaddirectory         267   // Invalid directory name in a path.
#define ERReasnotsupported      282   // Extended attributes
#define ERRbuftoosmall          2123
#define ERRunknownipc           2142
#define ERRnosuchprintjob       2151


// These errors seem to be only returned by the NT printer driver system

#define ERRunknownprinterdriver 1797  // ERROR_UNKNOWN_PRINTER_DRIVER
#define ERRinvalidprintername   1801  // ERROR_INVALID_PRINTER_NAME
#define ERRinvaliddatatype      1804  // ERROR_INVALID_DATATYPE
#define ERRinvalidenvironment   1805  // ERROR_INVALID_ENVIRONMENT
#define ERRprinterdriverinuse   3001  // ERROR_PRINTER_DRIVER_IN_USE

// Error codes for the ERRSRV class

#define ERRerror                1     // Non specific error code
#define ERRbadpw                2     // Bad password
#define ERRbadtype              3     // reserved
#define ERRaccess               4     // No permissions to do the requested operation
#define ERRinvnid               5     // tid invalid
#define ERRinvnetname           6     // Invalid servername
#define ERRinvdevice            7     // Invalid device
#define ERRqfull                49    // Print queue full
#define ERRqtoobig              50    // Queued item too big
#define ERRinvpfid              52    // Invalid print file in smb_fid
#define ERRsmbcmd               64    // Unrecognised command
#define ERRsrverror             65    // smb server internal error
#define ERRfilespecs            67    // fid and pathname invalid combination
#define ERRbadlink              68    // reserved
#define ERRbadpermits           69    // Access specified for a file is not valid
#define ERRbadpid               70    // reserved
#define ERRsetattrmode          71    // attribute mode invalid
#define ERRpaused               81    // Message server paused
#define ERRmsgoff               82    // Not receiving messages
#define ERRnoroom               83    // No room for message
#define ERRrmuns                87    // too many remote usernames
#define ERRtimeout              88    // operation timed out
#define ERRnoresource           89    // No resources currently available for request.
#define ERRtoomanyuids          90    // too many userids
#define ERRbaduid               91    // bad userid
#define ERRuseMPX               250   // temporarily unable to use raw mode, use MPX mode
#define ERRuseSTD               251   // temporarily unable to use raw mode, use standard mode
#define ERRcontMPX              252   // resume MPX mode
#define ERRbadPW                      // reserved
#define ERRnosupport            0xFFFF
#define ERRunknownsmb           22    // from NT 3.5 response

// Error codes for the ERRHRD class

#define ERRnowrite              19    // read only media
#define ERRbadunit              20    // Unknown device
#define ERRnotready             21    // Drive not ready
#define ERRbadcmd               22    // Unknown command
#define ERRdata                 23    // Data (CRC) error
#define ERRbadreq               24    // Bad request structure iSize
#define ERRseek                 25
#define ERRbadmedia             26
#define ERRbadsector            27
#define ERRnopaper              28
#define ERRwrite                29    // write fault
#define ERRread                 30    // read fault
#define ERRgeneral              31    // General hardware failure
#define ERRwrongdisk            34
#define ERRFCBunavail           35
#define ERRsharebufexc          36    // share buffer exceeded
#define ERRdiskfull             39

// protocol lists

#define ARCH_WFWG               0x03  // This is a fudge because WfWg is like Win95
#define ARCH_WIN95              0x02
#define ARCH_WINNT              0x04
#define ARCH_WIN2K              0x0C  // Win2K is like NT
#define ARCH_OS2                0x14  // Again OS/2 is like NT
#define ARCH_SAMBA              0x20
#define ARCH_ALL                0x3F

// these define the attribute byte as seen by DOS

#define aRONLY                  (1L<<0)
#define aHIDDEN                 (1L<<1)
#define aSYSTEM                 (1L<<2)
#define aVOLID                  (1L<<3)
#define aDIR                    (1L<<4)
#define aARCH                   (1L<<5)

// open modes

#define DOS_OPEN_RDONLY         0
#define DOS_OPEN_WRONLY         1
#define DOS_OPEN_RDWR           2



const char *SmbPacketType(int iType);
int ReplySpecial     (unsigned char *pIn,unsigned char *pOut);
int ReplyUnknown     (unsigned char *pIn,unsigned char *pOut);
int ReplyTcon        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyTconAndX    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyIoctl       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyCheckPath   (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyGetAttr     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySetAttr     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyDiskAttr    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySearch      (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyClose       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyFClose      (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyOpen        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyOpenAndX    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyULogoffX    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyMkNew       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyCTemp       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyUnlink      (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyReadBRaw    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyLockRead    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyRead        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyReadAndX    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyWriteAndX   (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyWriteBRaw   (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyWriteUnlock (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyWrite       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyLseek       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyFlush       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyExit        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyClose       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyWriteClose  (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyLock        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyUnlock      (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyTdis        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyEcho        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyPrintOpen   (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyPrintClose  (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyPrintQueue  (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyPrintWrite  (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyMkDir       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyRmDir       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyMove        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyCopy        (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySetDir      (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyLockingX    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySetAttrE    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyGetAttrE    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyTrans       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyFindClose   (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyFindNClose  (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyTranss2     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyTrans2      (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyNegprot     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyNtCancel    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyNtTranss    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyNtTrans     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySends       (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySendStrt    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySendText    (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySendEnd     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyNegprot     (SmbSession *pSeesion, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplySetupAndX   (SmbSession *pSession, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);
int ReplyNtCreateAndX(SmbSession *pSession, unsigned char *pIn,unsigned char *pOut, int iSize,int iBuffSize);

#endif
