/**************************************************************************/
/*                                                                        */
/*  File: NetCfg.h                               Copyright (c) 1996,2002  */
/*  Version: 4.0                                 On Time Informatik GmbH  */
/*                                                                        */
/*                                                                        */
/*                                      On Time        /////////////----- */
/*                                    Informatik GmbH /////////////       */
/* --------------------------------------------------/////////////        */
/*                                  Real-Time and System Software         */
/*                                                                        */
/**************************************************************************/

/* Network environment configuration file for the On Time RTOS-32 RTIP-32
   demos.

   Please define symbol DEVICE_ID to match your target's ethernet
   card and make sure that the card's hardware resource assigments are
   correct (for PCI cards, the drivers will determine this information
   automatically).

   If you do not compile and link the demo with DHCP defined, you must also
   edit the IP addresses NetMask, TargetIP, DefaultGateway, and DNSServer.

*/

// #define DHCP    // if you enable this, you must also link library dhcpc.lib
     
#ifndef DHCP
   static BYTE bNetMask[]        = {255, 255, 255,   0};
   static BYTE bTargetIP[]       = {192, 168,   0, 110};
   static BYTE bDefaultGateway[] = {192, 168,   0,   2};   // set to zero if not available or required
   static BYTE bDnsServer[]      = {192, 168,   0,   2};   // ditto
#endif

#define DEVICE_ID     LANCE_DEVICE   // define your device type here

#ifdef  __cplusplus
extern "C" {
#endif 

int SOCKAPI_ xn_bind_r8139_ex(int minor_number);
#define R8139_DEVICE_EX          125  /* Realtek 8139 */
#ifdef  __cplusplus
}
#endif 


#ifndef DEVICE_ID
   #error You must define Ethernet driver/resources and IP address/net mask here
#endif

#if DEVICE_ID == NE2000_DEVICE
   #define BIND_DRIVER   xn_bind_ne2000
   #define ED_IO_ADD     0x300
   #define ED_IRQ        5
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == TC90X_DEVICE
   #define BIND_DRIVER   xn_bind_tc90x
   // this is a PCI device and is configured at run-time
   #define ED_IO_ADD     0
   #define ED_IRQ        0
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == SMC91C9X_DEVICE
   #define BIND_DRIVER   xn_bind_smc91c9x
   #define ED_IO_ADD     0x1000
   #define ED_IRQ        10
   #define ED_MEM_ADD    0x04000000
#endif

#if DEVICE_ID == LANCE_DEVICE
   #define BIND_DRIVER   xn_bind_rtlance
   // this is a PCI device and is configured at run-time
   #define ED_IO_ADD     0
   #define ED_IRQ        0
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == LANCE_ISA_DEVICE
   #define BIND_DRIVER   xn_bind_lance_isa
   #define ED_IO_ADD     0x300
   #define ED_IRQ        5
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == CS89X0_DEVICE
   #define BIND_DRIVER   xn_bind_cs
   #define ED_IO_ADD     0x300
   #define ED_IRQ        5
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == I82559_DEVICE
   #define BIND_DRIVER   xn_bind_i82559
   // this is a PCI device and is configured at run-time
   #define ED_IO_ADD     0
   #define ED_IRQ        0
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == R8139_DEVICE
   #define BIND_DRIVER   xn_bind_r8139
   // this is a PCI device and is configured at run-time
   #define ED_IO_ADD     0
   #define ED_IRQ        0
   #define ED_MEM_ADD    0
#endif

#if DEVICE_ID == R8139_DEVICE_EX
   #define BIND_DRIVER   xn_bind_r8139_ex
   // this is a PCI device and is configured at run-time
   #define ED_IO_ADD     0
   #define ED_IRQ        0
   #define ED_MEM_ADD    0
#endif

#if defined(DEVICE_ID) && !defined(BIND_DRIVER)
   #error Invalid DEVICE_ID value
#endif
