//*****************************************************************************
//*
//*
//*     DgrServer.h
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//
//  Datagram Packet Format:
//
//   offset size
//      0     1     0x10    : direkt unique packet
//                  0x11    : direkt group packet
//                  0x12    : broadcast packet
//      1     1     bit 0   : more flag
//                  bit 1   : first flag
//                  bit 2-3 : 00=BNode 01=PNode 10=MNode
//      2     2     user id
//      4     4     source ip
//      8     2     source port
//     10     2     datagram lenght
//     12     2     packet offset
//     14     n     names
//

#include "DgrServer.h"
#include "NetBiosDebug.h"
#include "NmbInclude.h"
#include "NmbServer.h"
#include "NameDb.h"


#define     SETB(p,o,v)     *(unsigned char *)(((char*)(p))+(o))=(char )(v)
#define     SETW(p,o,v)     *(unsigned short*)(((char*)(p))+(o))=(short)(v)
#define     SETD(p,o,v)     *(unsigned int  *)(((char*)(p))+(o))=(int  )(v)
#define     GETB(p,o)       *(unsigned char *)(((char*)(p))+(o))
#define     GETW(p,o)       *(unsigned short*)(((char*)(p))+(o))
#define     GETD(p,o)       *(unsigned int  *)(((char*)(p))+(o))

#if         SU_USE_IPV6
#define     SETA(p,o,v)     SETD(p,o,((v).uAddr[1]))
#define     NULL_IP         {SU_IPV4_ID,0,0,0};
#else
#define     SETA(p,o,v)     SETD(p,o,v)
#define     NULL_IP         0
#endif

#define     SSWAP(l)        ((((l)>> 8)&0x000000FF)|(((l)<<8)&0x0000FF00))
#define     LSWAP(l)        ((((l)>>24)&0x000000FF)|(((l)>>8)&0x0000FF00)|  \
                             (((l)<<24)&0xFF000000)|(((l)<<8)&0x00FF0000))

           


#if DGR_PRINT
    #define     DGR_PRINT_PACKET
    #define     DGR_PACKET(a)       smb_printf a
    #define     DGR_MESSAGE(a)      smb_printf a
    #define     DRG_ERR_MESSAGE(a)  smb_printf a
    #define     DGR_PRINT_LOCK()    smb_plock()
    #define     DGR_PRINT_UNLOCK()  smb_punlock()
#else
    #define     DGR_PACKET(a)
    #define     DGR_MESSAGE(a)
    #define     DRG_ERR_MESSAGE(a)  default_printf a
    #define     DGR_PRINT_LOCK()
    #define     DGR_PRINT_UNLOCK()
#endif



static  SysSemaphore    hDrgUdpSema     = 0;
static  int             bDgrIsStarted   = 0;
static  int             bDgrIsRun       = 0;
static  UdpHandle       hDgram          = 0;
static  int             iDemonPriority  = 0;
static  unsigned        uLastElection   = 0;
static  IpAddr          ipBroadcast     = NULL_IP;
static  IpAddr          ipDgram         = NULL_IP;


extern  int     NmbPutName(char *pBuffer,const char *pName,const char *pDomain);
extern  int     NmbGetName(unsigned char *pName,char *pWinName,char *pPuffer,int iSize);

extern  char    cMyName[];
extern  char    cMyWorkgroup[];

unsigned        uDrgSendPackets=0;
unsigned        uDrgResvPackets=0;

#define         DGR_API     extern "C"

//*****************************************************************************
//*
//*     DgrName
//*
//*****************************************************************************
#ifdef  DGR_PRINT_PACKET
static int DgrName(unsigned char *pPacket)
{
unsigned char  *pStart=pPacket;
char            cBuffer[256];
int             i,j,first=1;


    if((pPacket[0]&0xC0)==0xC0)
        {
        DGR_PACKET(("0C0-00C        "));
        return 2;
        }

    while(i=*pPacket)
        {
        memcpy(cBuffer,pPacket+1,i);
        cBuffer[i]=0;
        if(first)
            {
            for(j=0;j<32;j++)cBuffer[j]-='A';
            for(j=0;j<16;j++)cBuffer[j] =(cBuffer[j*2]<<4)+cBuffer[j*2+1];
            sprintf(cBuffer+11,"<%02X>",cBuffer[15]&0xFF);
            first=0;
            }

        DGR_PACKET(("%s",cBuffer));
        pPacket+=i+1;
        if(*pPacket)DGR_PACKET(("."));
        }
    pPacket++;

return pPacket-pStart;
}


//*****************************************************************************
//*
//*     DgrPrintPacket
//*
//*****************************************************************************
//  Prints a debug message
static void DgrPrintPacket(const void *pPacketPtr,int iSize)
{
int             iType,iName;
unsigned char  *pPacket=(unsigned char*)pPacketPtr;
static char    *pDgrTypes[]=
                    {    /*  0 */  "???",
                         /*  1 */  "HostAnnouncement   ",
                         /*  2 */  "AnnouncementRequest",
                         /*  3 */  "???",
                         /*  4 */  "???",
                         /*  5 */  "???",
                         /*  6 */  "???",
                         /*  7 */  "???",
                         /*  8 */  "Election",
                         /*  9 */  "GetBackupListReq   ",
                         /* 10 */  "GetBackupListResp  ",
                         /* 11 */  "BecomeBackup",
                         /* 12 */  "DomainAnnouncement ",
                         /* 13 */  "MasterAnnouncement ",
                         /* 14 */  "ResetBrowserState  ",
                         /* 15 */  "LocalMasterAnnouncement"
                    };


    DGR_PACKET(("\n\tSize:%i\n",iSize));
    DGR_PACKET(("\tiType  %02X",pPacket[0]));
    DGR_PACKET(("\tFlags %c %c %i", (pPacket[1]& 1)? 'm':'_',
                                    (pPacket[1]& 2)? 'f':'_',
                                    (pPacket[1]>>2)&3));
    //DGR_PACKET(("\n\tID %02X%02X",pPacket[2],pPacket[3]));
    //DGR_PACKET(("  %i.%i.%i.%i\t",pPacket[4],pPacket[5],pPacket[6],pPacket[7]));
    //DGR_PACKET(("Port %i\t"  ,pPacket[8]*256+pPacket[9]));
    DGR_PACKET(("L=%i O=%i\t",pPacket[10]*256+pPacket[11],pPacket[12]*256+pPacket[13]));

    iType=pPacket[0];
    pPacket+=14;

    if(iType==0x10 || iType==0x11 || iType==0x12)
        {
        DGR_PACKET(("\n\tname=\""));
        pPacket+=DgrName(pPacket);
        DGR_PACKET(("\"  \n\tname=\""));
        pPacket+=DgrName(pPacket);
        DGR_PACKET(("\" "));
        }

    if(memcmp(pPacket,"\xFFSMB\x25",5))
        {
        DGR_PACKET(("\n\tno SMB"));
        return;
        }

    iName=39-4+pPacket[32]*2;
    DGR_PACKET(("\n\tSMB \"%s\"",pPacket+iName));
    pPacket += pPacket[57]+pPacket[58]*256;
    DGR_PACKET(("\tcom: %02X \"%s\"\n",pPacket[0],(pPacket[0]<16)? pDgrTypes[pPacket[0]]:"???"));

}
#else
#define DgrPrintPacket(p,s)
#endif


//*****************************************************************************
//*
//*     DgrRestartInterface
//*
//*****************************************************************************
static void DgrRestartInterface()
{
    DRG_ERR_MESSAGE(("\nRestart DRG Interface"));
    DgrStopDaemon();
    DgrDaemon(ipDgram,ipBroadcast,iDemonPriority);
    SysThreadExit();
}


//*****************************************************************************
//*
//*     DgrAnnounce
//*
//*****************************************************************************
//  Send an announce for a comuter to the network
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
//  pName1  : 16 Byte long workgroup, byte 15 is the type,
//            the rest must be filled with spaces
DGR_API int  DgrAnnounce(const char *pName,const char *pDomain,int  bGroup,const char *pName1)
{
char    cBuffer[600];
char    cName[16],cName1[16];
int     iPos,i;


    DGR_MESSAGE(("\nDgrAnnounce"));

    memcpy(cName ,pName ,16);
    memcpy(cName1,pName1,16);
    cName [15]=0x00;
    cName1[15]=0x1D;



    SETW(cBuffer,0,0x0211);                                     // type and flags
    SETW(cBuffer,2,0x1234);                                     // id
    SETA(cBuffer,4,ipDgram);                                    // ip address
    SETW(cBuffer,8,SSWAP(DGRAM_PORT));                          // port
    SETW(cBuffer,12,0);                                         // offset

    iPos =14;                                                   // names
    iPos+=NmbPutName(cBuffer+iPos,cName ,pDomain);
    iPos+=NmbPutName(cBuffer+iPos,cName1,pDomain);

                                                                // smb block
    SETD(cBuffer,iPos   ,0x424D53FF);                           // "\xFFSMB"
    SETD(cBuffer,iPos+ 4,0x00000025);
    memset(cBuffer+iPos+8,0,35+17*2-8);
    cBuffer[iPos+4+1+27]=17;
    iPos+=35;

    SETW(cBuffer,iPos   ,33);
    SETW(cBuffer,iPos+20,33);
    SETW(cBuffer,iPos+22,86);
    SETD(cBuffer,iPos+24,0x00010003);
    SETD(cBuffer,iPos+28,0x00020001);
    SETW(cBuffer,iPos+32,50);
    iPos+=34;
    memcpy(cBuffer+iPos,"\\MAILSLOT\\BROWSE",17);
    iPos+=17;

    SETW(cBuffer,iPos   ,0x0301);                               // announce block
    SETD(cBuffer,iPos+2 ,60000);

    for(i=14;i>0;i--)if(pName[i]!=' ')break;
    i++;

    memcpy(cBuffer+iPos+6  ,pName,i);
    memset(cBuffer+iPos+6+i,0 ,16-i);

    SETW(cBuffer,iPos+22,0x0004);
    SETD(cBuffer,iPos+24,0x00402003);
    SETW(cBuffer,iPos+28,0x0415);
    SETW(cBuffer,iPos+30,0xAA55);
    cBuffer[iPos+32]=0;
    iPos+=33;

    SETW(cBuffer,10,SSWAP(iPos-14));                            // length

    if(UdpPut(hDgram,&ipBroadcast,cBuffer,iPos)>0)
        {
        uDrgSendPackets++;
        }




return TRUE;
}


//*****************************************************************************
//*
//*     DgrStopDaemon
//*
//*****************************************************************************
//  Return TRUE if all ok
DGR_API int  DgrStopDaemon()
{
int     i;
int     bOk=TRUE;


    if(!bDgrIsStarted)return FALSE;
    bDgrIsStarted=FALSE;
    UdpClose(hDgram);
    SysSemaphoreDelete(hDrgUdpSema);
    hDrgUdpSema=0;

    for(i=0;i<16;i++)
        {
        if(!bDgrIsRun)break;
        SysSleep(200);
        if(i==15)bOk=FALSE;
        }

    hDgram=0;

return bOk;
}



//*****************************************************************************
//*
//*     DgrResive
//*
//*****************************************************************************
//  Resive function for datagram packets
static void DgrResive(void *pParam)
{
IpAddr           ipFrom=NULL_IP;
unsigned char    ucPacket[2048];
char             cName1[16],cDomain1[16];
char             cName2[16],cDomain2[16];
int              iSize,iPos,iLen,iName;
int              iError,iOffset;



    DGR_MESSAGE(("\nDgrResive auf %u.%u.%u.%u\n",(GetIpV4(&ipDgram))&0xFF,(GetIpV4(&ipDgram)>>8)&0xFF,(GetIpV4(&ipDgram)>>16)&0xFF,(GetIpV4(&ipDgram)>>24)&0xFF));

    bDgrIsRun = TRUE;
    iError    = 0;

    while(bDgrIsStarted)
        {
            iSize=UdpGet(hDgram,&ipFrom,ucPacket,sizeof(ucPacket));
        if( iSize<6)
            {
            if(iSize <0)iError++;
            if(iError>4)DgrRestartInterface();
            SysSleep(50);
            continue;
            }

        uDrgResvPackets++;

        DGR_PRINT_LOCK();
        DGR_MESSAGE(("\nDgrResive: --->"));
        DgrPrintPacket(ucPacket,iSize);
        DGR_PRINT_UNLOCK();

        iError=0;

        if(ucPacket[0]!=0x10)
        if(ucPacket[0]!=0x11)
        if(ucPacket[0]!=0x12)continue;

        iPos=14;
        iPos+=NmbGetName(ucPacket+iPos,cName1,cDomain1,sizeof(cDomain1));
        iPos+=NmbGetName(ucPacket+iPos,cName2,cDomain2,sizeof(cDomain2));

        if(GETD(ucPacket,iPos  )!=0x424D53FF)continue;
        if(GETB(ucPacket,iPos+4)!=0x25)continue;

        iLen    = GETW(ucPacket,iPos+55);
        iOffset = GETW(ucPacket,iPos+57)+iPos;
        iName   = GETB(ucPacket,iPos+32)*2+35+iPos;

        if(memcmp(ucPacket+iName,"\\MAILSLOT\\BROWSE",17))continue;

        switch(ucPacket[iOffset])
            {
        case 8: uLastElection=SysTickCount();
                //DgrElection(cMyName,0,0,cMyWorkgroup);
                break;
            }

        }

    bDgrIsRun=FALSE;

}


//*****************************************************************************
//*
//*      DgrDaemon
//*
//*****************************************************************************
//  Start the datagramm server
DGR_API int DgrDaemon(IpAddr ipAddress,IpAddr ipBcast,int iPriority)
{


    if(bDgrIsStarted     )return TRUE;
    if(IsIpV6(&ipBcast  ))return FALSE;     /* ipv6 not allowed */
    if(IsIpV6(&ipAddress))return FALSE;


    hDrgUdpSema     = SysSemaphoreCreate();
    iDemonPriority  = iPriority;
    ipBroadcast     = ipBcast;
    ipDgram         = ipAddress;

        hDgram  = UdpOpen(&ipAddress,DGRAM_PORT,TRUE,FALSE);
    if(!hDgram)return FALSE;


    bDgrIsStarted=TRUE;                     /* start recieve thread */
    SysThreadStart(DgrResive,0x4000,0,iPriority|SYS_GLOBAL,"DRG Resive");


return TRUE;
}

//*****************************************************************************
//*
//*      DgrElection
//*
//*****************************************************************************
//  Send an election message for a local master
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
//  pName1  : 16 Byte long workgroup, byte 15 is the type,
//            the rest must be filled with spaces
DGR_API int DgrElection(const char *pName,const char *pDomain,int bGroup,const char *pName1)
{
char    cBuffer[600];
char    cName[16],cName1[16];
int     iPos,iLen;


    DGR_MESSAGE(("\nDgrElection"));

    memcpy(cName ,pName ,16);
    memcpy(cName1,pName1,16);
    cName [15]=0x20;
    cName1[15]=0x1E;

    for(iLen=0;iLen<15;iLen++)                  /* servername lenght */
        {
        if(pName[iLen]==' ')break;
        if(pName[iLen]== 0 )break;
        }

    /* build election packet */

    SETW(cBuffer,0,0x0211);                     /* type and flags */
    SETW(cBuffer,2,0x1234);                     /* id */
    SETA(cBuffer,4,ipDgram);                    /* ip address */
    SETW(cBuffer,8,SSWAP(DGRAM_PORT));          /* port */
    SETW(cBuffer,12,0);                         /* offset */


    iPos =14;                                   /* names */
    iPos+=NmbPutName(cBuffer+iPos,cName ,pDomain);
    iPos+=NmbPutName(cBuffer+iPos,cName1,pDomain);

                                                /* smb block */
    SETD(cBuffer,iPos  ,0x424D53FF);            /* "\xFFSMB" */
    SETD(cBuffer,iPos+4,0x00000025);
    memset(cBuffer+iPos+8,0,35+17*2-8);
    SETB(cBuffer,iPos+4+1+27,17);               /* word count (14+3) */
    iPos+=33;

    SETW(cBuffer,iPos+ 2,15+iLen);              /* total data send */
    SETW(cBuffer,iPos+22,15+iLen);              /* data send */
    SETW(cBuffer,iPos+24,86);                   /* data offset */
    SETD(cBuffer,iPos+26,0x00010003);           /* setup data */
    SETD(cBuffer,iPos+30,0x00020001);           /* setup data */
    SETW(cBuffer,iPos+34,32+iLen);              /* byte count */
    iPos+=17*2+2;


    SETB(cBuffer,iPos  ,8);                     /* election block */
    SETB(cBuffer,iPos+1,1);                     /* election version */
    SETD(cBuffer,iPos+2,0);                     /* criterion */
    SETD(cBuffer,iPos+6,0);                     /* timeup in ms  */

    memcpy(cBuffer+14,pName,iLen);
    iPos+=15+iLen;

    SETW(cBuffer,10,SSWAP(iPos-14));            /* length */


    if(UdpPut(hDgram,&ipBroadcast,cBuffer,iPos)>0)
        {
        uDrgSendPackets++;
        }




return TRUE;
}

//*****************************************************************************
//*
//*      DgrElectionStart
//*
//*****************************************************************************
//  Starts an election for a local master
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
//  pName1  : 16 Byte long workgroup, byte 15 is the type,
//            the rest must be filled with spaces
DGR_API int DgrElectionStart(const char *pName,const char *pDomain,int bGroup,const char *pName1)
{
char    cBuffer[600];
char    cName[16],cName1[16];
int     iPos;


    DGR_MESSAGE(("\nDgrElection"));

    memcpy(cName ,pName ,16);
    memcpy(cName1,pName1,16);
    cName [15]=0x00;
    cName1[15]=0x1E;


    /* build election packet */


    SETW(cBuffer,0,0x0211);                     /* type and flags */
    SETW(cBuffer,2,0x1234);                     /* id */
    SETA(cBuffer,4,ipDgram);                    /* ip address */
    SETW(cBuffer,8,SSWAP(DGRAM_PORT));          /* port */
    SETW(cBuffer,12,0);                         /* offset */


    iPos =14;                                   /* names */
    iPos+=NmbPutName(cBuffer+iPos,cName ,pDomain);
    iPos+=NmbPutName(cBuffer+iPos,cName1,pDomain);

                                                /* smb block */
    SETD(cBuffer,iPos  ,0x424D53FF);            /* "\xFFSMB" */
    SETD(cBuffer,iPos+4,0x00000025);
    memset(cBuffer+iPos+8,0,35+17*2-8);
    SETW(cBuffer,iPos+4+1+19,0xFFFF);           /* TID */
    SETW(cBuffer,iPos+4+1+23,0xFFFF);           /* UID */
    SETB(cBuffer,iPos+4+1+27,17);               /* word count (14+3) */
    iPos+=33;

    SETW(cBuffer,iPos+ 2,30);                   /* total data send */
    SETW(cBuffer,iPos+10, 2);                   /* flags */
    SETW(cBuffer,iPos+24,86);                   /* data offset */
    SETW(cBuffer,iPos+22,30);                   /* data send */
    SETW(cBuffer,iPos+24,88);                   /* data offset */
    SETD(cBuffer,iPos+26,0x00010003);           /* setup data */
    SETD(cBuffer,iPos+30,0x00020001);           /* setup data */
    SETW(cBuffer,iPos+34,49);                   /* byte count */
    iPos+=17*2+2;

    memcpy(cBuffer+iPos,"\\MAILSLOT\\BROWSE\x00\x33\x42",19);
    iPos+=19;

    SETD(cBuffer,iPos,0x0008);                  /* election block */
    memset(cBuffer+iPos+4,0,26);
    iPos+=30;

    SETW(cBuffer,10,SSWAP(iPos-14));            /* length */

    if(UdpPut(hDgram,&ipBroadcast,cBuffer,iPos)>0)
        {
        uDrgSendPackets++;
        }


return TRUE;
}



//*****************************************************************************
//*
//*      DgrLastElection
//*
//*****************************************************************************
//  Returns the Time off the last recived election
DGR_API unsigned DgrLastElection()
{
    return uLastElection;
}


