#ifndef COUNTDOWN_H
#define COUNTDOWN_H

/*
  TimerJinni - A general timing application
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Audio/PlaySound.h>

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Boolean.h>
#include <Lum/Model/Number.h>

#include "StopWatch.h"

class Countdown : public Lum::Component
{
private:
  enum State {
    stateUninitialized,
    statePaused,
    stateStoped,
    stateRunning,
    stateAlerting
  };

private:
  Lum::Model::ActionRef  startAction;
  Lum::Model::BooleanRef paused;
  Lum::Model::ActionRef  stopAction;
  Lum::Model::ActionRef  timer;

  unsigned long          initialSeconds;
  Lum::Base::Timer       time;

  State                  state;
  StopWatch              *clock;
  Lum::Base::SystemTime  alertTime;

  Lum::Audio::PlaySound  *beepSound;

private:
  void SetValue();
  void PlayAlert();
  void AllowScreenBlanking(bool allow);
  void SetState(State state);

public:
  Countdown();
  ~Countdown();

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
