#!/bin/sh
# cd /usr/lib/hildon-desktop
#
# Widget 
# 
# Realized by m750 at smartphonetab.net



APP_TITLE = "tilt2control"
APP_VERSION = "1.0.0-x"

import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import osso
import string
import time 
import dbus

APP_NAME = APP_TITLE.lower()
PERCORSO = '/home/user/tilt2control/'
LOGO = PERCORSO + '%s_on.png' % APP_NAME


class tilt2control(hildondesktop.HomePluginItem):

  global attivo
  attivo = 0
    
  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    self.set_settings(True)
    self.connect("show-settings", self.show_options)

    self.isStopped = True 
    self.update_info()
    self.transparency = 0.0

  

  def update_info(self, widget=None):

    #self.osso_context = osso.Context("com.tomch.bluezwitch", str(APP_VERSION), False)
    #self.osso_rpc = osso.Rpc(self.osso_context)
   
    self.hbox = gtk.HBox()
    self.vbox = gtk.VBox()
    self.e_eventbox = gtk.EventBox()
    self.e_eventbox.set_size_request(64, 72)           
    self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
    self.e_eventbox.connect("button-release-event", self.on_toggle)
    self.hbox.pack_start(self.e_eventbox, True, True, 10)
    self.hbox.show_all()
    self.add(self.hbox)
    
  def do_expose_event(self, event):
    cr = self.window.cairo_create()
    cr.set_source_rgba(1.0, 1.0, 1.0, self.transparency) # Transparent
    cr.set_operator(cairo.OPERATOR_SOURCE)
    cr.paint()   

    # Paint icon for eventbox
    self.draw_e("tilt2control_off.png")

    # draw rounded rect
    width, height = self.allocation[2], self.allocation[3]
    
    x0 = 0
    y0 = 0
    radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
    x1 = x0 + width
    y1 = y0 + height 
    
    cr.move_to  (x0, y0 + radius)
    cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
    cr.line_to (x1 - radius, y0)
    cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
    cr.line_to (x1 , y1 - radius)
    cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
    cr.line_to (x0 + radius, y1)
    cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
    cr.close_path ()

    cr.set_source_rgba (0.0, 0.0, 0.0, self.transparency)
    cr.fill_preserve ()
    return False

  def draw_e(self,icon):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)

    image = cairo.ImageSurface.create_from_png(PERCORSO + icon)
    
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
    self.cr_e = cr_e
    while gtk.events_pending():
      gtk.main_iteration()
          
  def do_realize(self):
    screen = self.get_screen()
    colormap = screen.get_rgba_colormap()
    self.set_colormap(colormap)
    hildondesktop.HomePluginItem.do_realize(self) 

  def get_rotation(self, widget=None):
	f=os.popen('cat /sys/class/i2c-adapter/i2c-3/3-001d/coord').read()
	coords = [int(w) for w in f.split()]
	return coords

  def get_proximity(self, widget=None):
	f = open("/sys/devices/platform/gpio-switch/proximity/state", 'r' )
	state = f.readline()
	state = state.rstrip()
	return state

  def attiva(self,widget=None):
     global attivo
     time.sleep(0.1)
     while gtk.events_pending():
		gtk.main_iteration(False)
     time.sleep(0.1)
     while gtk.events_pending():
		gtk.main_iteration(False)

     while attivo==1:

       # permette interazione con altri eventi
	while gtk.events_pending():
		gtk.main_iteration(False)

	coor = self.get_rotation()
	time.sleep(0.1)
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.1)
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.1)
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.1)
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.1)
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.1)
	while gtk.events_pending():
		gtk.main_iteration(False)





	state = self.get_proximity()
	#print state
	if state == "open" :

		x = coor[0]
		y = coor[1]
		z = coor[2]

		#print x, y, z

		if x<-400 and x>-600:
			print "successivo"
			os.popen('dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.next')

			banner = hildon.hildon_banner_show_information(self, '', "tilt2control: next track")
			banner.set_timeout(1800)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)



		if x>400 and x<600:
	
			print "precedente"	
			os.popen('dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.previous')

			banner = hildon.hildon_banner_show_information(self, '', "tilt2control: previous track")
			banner.set_timeout(1800)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)



		if y<-400 and y>-600:
			print "pausa"	
			os.popen('dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.pause')

			banner = hildon.hildon_banner_show_information(self, '', "tilt2control: pause")
			banner.set_timeout(1800)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)


		if y>400 and y<600:
			print "riprendi"	
			os.popen('dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.resume')

			banner = hildon.hildon_banner_show_information(self, '', "tilt2control: resume track")
			banner.set_timeout(1800)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration(False)



	elif state == "closed" :
		time.sleep(0.1)
		while gtk.events_pending():
			gtk.main_iteration(False)
		time.sleep(0.1)
		while gtk.events_pending():
			gtk.main_iteration(False)
		time.sleep(0.1)
		while gtk.events_pending():
			gtk.main_iteration(False)
		time.sleep(0.1)
		while gtk.events_pending():
			gtk.main_iteration(False)





  def on_toggle(self, button, data=None):
    global attivo

    if attivo == 0:
       attivo = 1
       self.draw_e("tilt2control_on.png")
       time.sleep(0.2) 
       while gtk.events_pending():
		gtk.main_iteration(False)

       banner = hildon.hildon_banner_show_information(self, '', "tilt2control attivato")
       banner.set_timeout(1800)
       time.sleep(0.2) 
       while gtk.events_pending():
		gtk.main_iteration(False)
       os.popen('dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.play')
       time.sleep(0.2)
       while gtk.events_pending():
		gtk.main_iteration(False)
       self.attiva()

    else:
       attivo = 0
       self.draw_e("tilt2control_off.png")
       time.sleep(0.2)
       while gtk.events_pending():
		gtk.main_iteration(False)
       banner = hildon.hildon_banner_show_information(self, '', "tilt2control disattivato")
       banner.set_timeout(1800)
       os.popen('dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.stop')


    #print attivo

  
  #Setup the main options/settings dialogue (the one accessible through the tool icon when in Hildon Desktop Edit mode)
  def show_options(self, widget):
      dialog = gtk.Dialog("%s Options" % APP_TITLE, None, gtk.DIALOG_DESTROY_WITH_PARENT)

     
      
      about_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      about_button.set_text("About", "Information")
      about_button.set_alignment(0,0,0,0)
      about_button.connect("clicked", self.show_about)

      line1 = gtk.HBox()
      line2 = gtk.HBox()        
      line2.pack_start(about_button, True, True, 0)
      dialog.vbox.pack_start(line1, True, True, 0)  
      dialog.vbox.pack_start(line2, True, True, 0)  
       
      dialog.show_all()
      dialog.run()
      dialog.destroy()
  
 
  
  #Show the about dialog    
  def show_about(self, widget):
      dialog = gtk.AboutDialog()


      dialog.set_title("About")
      dialog.set_name("tilt2control")
      dialog.set_version(APP_VERSION)
      dialog.set_copyright("2011 by M750")
      dialog.set_logo(gtk.gdk.pixbuf_new_from_file(LOGO))
      dialog.set_comments("tilt to control mplayer")
 
      dialog.set_authors(["widget to control the track's execution by tilting your n900","by m750 at smartphonetab.net","",
       "From the desktop position tilt your n900 45 degrees to:",
       "- left: previous tack",
	"- right: next track",
	"- forwar: resume track",
       "- back: pause"])

      dialog.set_license("This is free software")
      dialog.set_wrap_license(True)

      dialog.show_all()
      dialog.run()
      dialog.destroy() 
  
hd_plugin_type = tilt2control

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
