/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef GRAPHICSSCENE_H
#define GRAPHICSSCENE_H

#include "shape.h"
#include "machineia.h"
#include "finalline.h"

#include <QGraphicsScene>
#include <QPropertyAnimation>

class GraphicsScene : public QGraphicsScene 
{
	Q_OBJECT
	public:
		GraphicsScene(QObject* parent = 0);
		~GraphicsScene() 
		{
			delete m_winner;
			delete m_restart;
			delete m_textLevel;
			delete fl;
			qDeleteAll(m_grid.begin(), m_grid.end() );
		};
		void changeLevel();
		void restartGame();
// 		void askUserName();
		void statistics();
		void changeShape();
	private slots:
		void endUserAnimation();
		void endMachineAnimation();
	private:
		void endFinalLine();
		void CPUMove();
		bool checkFinish();
		virtual void mousePressEvent(QGraphicsSceneMouseEvent* event);
		bool algunaCasillaLibre();
		void cleanAll();
		void changeLevel(int level);
		void updateLevelText();
		
		enum DataInside {
			Positions,
			Shapes
		};
		enum Positions {
			TopLeft, TopMiddle, TopRight,
			MiddleLeft, MiddleMiddle, MiddleRight,
			BottomLeft, BottomMiddle, BottomRight, All };
		enum Shapes {
			Empty, 
			Machine, 
			Human,
			Img
		};
		
		QVector<Shape*> m_grid;
		MachineIA m_machine;
		int matrix[3][3];
		QPropertyAnimation* animOp;
		FinalLine* fl;
		bool block;
		QGraphicsTextItem* m_textLevel;
		QGraphicsTextItem* m_winner;
		QGraphicsTextItem* m_restart;
// 		QString userName;
		int ganador;
		bool endGame;
		int win;
		int lose;
		int draw;
		QChar userImg;
};

#endif // GRAPHICSSCENE_H
