/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */



#include <cstdlib>
#include <cmath>
#include <gtkmm/dialog.h>
#include <gtkmm/main.h>
#include <gtkmm/notebook.h>

#include <ting/Exc.hpp>
#include <ting/math.hpp>
#include <ting/Array.hpp>
#include <ting/Ref.hpp>
#include <ting/Ptr.hpp>
#include <pugixml/pugixml.hpp>

#include "stdafx.hpp"
#include "dialogs/AboutDialog.hpp"
#include "MainWindow.hpp"
#include "File.hpp"
#include "FSFile.hpp"
#include "Preferences.hpp"



using namespace ting;



MainWindow::MainWindow() :
		isFullscreen(false),
		optionsMenuItem("Options"),
		exitMenuItem("Exit"),
		aboutMenuItem("About")
{
	this->set_default_size(800, 480);

	this->signal_key_press_event().connect(
			sigc::mem_fun(*this, &MainWindow::OnKeyPress)
		);

	//menu
	this->optionsMenuItem.set_size_request(-1, DFingerFriendlyMinSize());
	this->mainMenu.append(this->optionsMenuItem);
	this->optionsMenuItem.signal_activate().connect(
			sigc::mem_fun(*this, &MainWindow::OpenOptionsDialog)
		);
	this->optionsMenuItem.set_sensitive(false);

	this->mainMenu.append(*Gtk::manage(new Gtk::SeparatorMenuItem()));

	this->exitMenuItem.set_size_request(-1, DFingerFriendlyMinSize());
	this->mainMenu.append(this->exitMenuItem);
	this->exitMenuItem.signal_activate().connect(
			sigc::mem_fun(*this, &MainWindow::Exit)
		);

	this->mainMenu.append(*Gtk::manage(new Gtk::SeparatorMenuItem()));

	this->aboutMenuItem.set_size_request(-1, DFingerFriendlyMinSize());
	this->mainMenu.append(this->aboutMenuItem);
	this->aboutMenuItem.signal_activate().connect(
			sigc::mem_fun(*this, &MainWindow::ShowAboutDialog)
		);

	this->mainMenu.show_all();//Show the main menu and all its child widgets.
#ifndef M_NON_MAEMO_LINUX
	this->set_main_menu(this->mainMenu);
#else
	this->add(this->mainMenu);
#endif

	this->add(this->notebook);

	//Notebook
	this->notebook.set_show_border(false);
	this->notebook.set_show_tabs(false);

	this->notebook.append_page(this->mainMenuView);
	this->notebook.append_page(this->thereminView);
	this->notebook.append_page(this->listenView);
	this->notebook.append_page(this->keyboardView);

	this->show_all_children();//Show all window child widgets
}



void MainWindow::Exit(){
	Gtk::Main::quit();
}



void MainWindow::ShowAboutDialog(){
	AboutDialog d(*this);
	d.run();
	d.hide();
}



struct MenuPlacer{
	int menuX, menuY;
	void onPopupMenuPosition(int& x, int& y, bool& pushIn){
		x = this->menuX;
		y = this->menuY;
		pushIn = true;
	}
};



bool MainWindow::OnKeyPress(GdkEventKey* event){
	TRACE(<<"OnKeyPress(): keyval = " << event->keyval << std::endl)
	switch(event->keyval){
		case GDK_F6:
//			TRACE(<<"OnKeyPress(): f6 pressed" << std::endl)
			if(this->isFullscreen)
				this->unfullscreen();
			else
				this->fullscreen();
			this->isFullscreen = !this->isFullscreen;
			break;

		case GDK_F4:
			{
				Glib::RefPtr<Gdk::Window> window = this->get_window();
				if(!window)
					return false;

				MenuPlacer placer;
				window->get_origin(placer.menuX, placer.menuY);

				this->mainMenu.popup(sigc::mem_fun(placer, &MenuPlacer::onPopupMenuPosition), 0, 0);
			}
			break;
		default:
			return false;
			break;
	}
	return true;
}


