/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <gtkmm/box.h>
#include <gtkmm/widget.h>

#include <ting/Ptr.hpp>

#include "stdafx.hpp"
#include "MainMenuView.hpp"
#include "MainWindow.hpp"
#include "dialogs/NetworkSettingsDialog.hpp"



using namespace ting;



MainMenuView::MainMenuView(){
	{
		Gtk::VBox *vbox = new Gtk::VBox();
		this->add(*Gtk::manage(vbox));

		Gtk::Button *tb = new Gtk::Button("Theremin");
		vbox->add(*Gtk::manage(tb));
		tb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainMenuView::ShowThereminScreen)
			);

		Gtk::Button *nb = new Gtk::Button("Network settings");
		vbox->add(*Gtk::manage(nb));
		nb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainMenuView::ShowNetworkSettingsDialog)
			);
	}

	{
		Gtk::VBox *vbox = new Gtk::VBox();
		this->add(*Gtk::manage(vbox));

		Gtk::Button *kb = new Gtk::Button("Keyboard");
		vbox->add(*Gtk::manage(kb));
		kb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainMenuView::ShowKeyboardScreen)
			);
		
		Gtk::Button *lb = new Gtk::Button("Listen others");
		vbox->add(*Gtk::manage(lb));
		lb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainMenuView::ShowListenOthersScreen)
			);


	}
}



void MainMenuView::ShowThereminScreen(){
	MainWindow::Inst().ShowThereminScreen();
}



void MainMenuView::ShowListenOthersScreen(){
	MainWindow::Inst().ShowListenOthersScreen();
}



void MainMenuView::ShowKeyboardScreen(){
	MainWindow::Inst().ShowKeyboardScreen();
}



void MainMenuView::ShowNetworkSettingsDialog(){
	NetworkSettingsDialog d(MainWindow::Inst());

	d.set_deletable(false);
	d.run();
	d.hide();
	TRACE(<< "MainMenuView::ShowNetworkSettingsDialog(): network settings dialog exited" << std::endl)
}
