/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
 * aumiks 0.1
 *
 * File:   PulseAudio.hpp
 * Author: ivan
 *
 * Created on March 9, 2009, 3:22 PM
 */

#pragma once

#include <pulse/simple.h>
#include <pulse/error.h>

#include "AudioBackend.hpp"

#include "../Exc.hpp"

namespace aumiks{

class PulseAudioBackend : public AudioBackend{
	 pa_simple *handle;

public:
	PulseAudioBackend(ting::uint requestedBufferSizeInFrames){
		//TODO: get actual buffer size from pulseaudio
		this->bufSizeInFrames = requestedBufferSizeInFrames;
		this->sampleSizeInBytes = 2;
		this->numChannels = 2;
		
		TRACE(<< "opening device" << std::endl)

		pa_sample_spec ss;
		ss.format = PA_SAMPLE_S16NE;
		ss.channels = 2;
		ss.rate = 44100;

		pa_buffer_attr ba;
		ba.fragsize = this->BufferSizeInBytes();
		ba.maxlength = 2 * this->BufferSizeInBytes();
		ba.prebuf = this->BufferSizeInBytes();
		ba.minreq = this->BufferSizeInBytes();
		ba.tlength = this->BufferSizeInBytes();


		pa_channel_map cm;
		pa_channel_map_init_auto(&cm, ss.channels, PA_CHANNEL_MAP_WAVEEX);

		int error;

		this->handle = pa_simple_new(
				0, // Use the default server.
				"aumiks", // Our application's name.
				PA_STREAM_PLAYBACK,
				0, // Use the default device.
				"Music", // Description of our stream.
				&ss, // our sample format.
				&cm, // channel map
				&ba, // buffering attributes.
				&error
			);

		if(!this->handle){
			TRACE(<< "error opening PulseAudio connection (" << pa_strerror(error) << ")" << std::endl)
			throw aumiks::Exc("error opening PulseAudio connection");
		}
	}



	~PulseAudioBackend(){
		ASSERT(this->handle)
		pa_simple_free(this->handle);
	}



	//override
	void Write(const ting::Buffer<ting::byte>& buf){
		ASSERT(buf.Size() == this->BufferSizeInBytes())

		if(pa_simple_write(
				this->handle,
				buf.Buf(),
				size_t(buf.SizeInBytes()),
				0 // no error return
			) < 0)
		{
			//ignore error
			TRACE(<< "pa_simple_write(): error" << std::endl)
        }
	}

};

}//~namespace
